package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.programming.rev181109;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.Nanotime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.SubmitInstructionInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.LspId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * Class that builds {@link SubmitRemoveLspInput} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SubmitRemoveLspInput createSubmitRemoveLspInput(int fooXyzzy, int barBaz) {
 *         return new SubmitRemoveLspInputBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SubmitRemoveLspInput, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SubmitRemoveLspInput
 *
 */
@Generated("mdsal-binding-generator")
public class SubmitRemoveLspInputBuilder {

    private Nanotime _deadline;
    private InstructionId _id;
    private String _name;
    private NetworkTopologyRef _networkTopologyRef;
    private NodeId _node;
    private Set<InstructionId> _preconditions;


    Map<Class<? extends Augmentation<SubmitRemoveLspInput>>, Augmentation<SubmitRemoveLspInput>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public SubmitRemoveLspInputBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link SubmitInstructionInput}.
     *
     * @param arg SubmitInstructionInput from which the builder should be initialized
     */
    public SubmitRemoveLspInputBuilder(SubmitInstructionInput arg) {
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
    }
    
    /**
     * Construct a new builder initialized from specified {@link NetworkTopologyReference}.
     *
     * @param arg NetworkTopologyReference from which the builder should be initialized
     */
    public SubmitRemoveLspInputBuilder(NetworkTopologyReference arg) {
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link LspId}.
     *
     * @param arg LspId from which the builder should be initialized
     */
    public SubmitRemoveLspInputBuilder(LspId arg) {
        this._name = arg.getName();
        this._node = arg.getNode();
    }
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.NodeId}.
     *
     * @param arg org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.NodeId from which the builder should be initialized
     */
    public SubmitRemoveLspInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.NodeId arg) {
        this._node = arg.getNode();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link SubmitRemoveLspInput}.
     *
     * @param base SubmitRemoveLspInput from which the builder should be initialized
     */
    public SubmitRemoveLspInputBuilder(final SubmitRemoveLspInput base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._deadline = base.getDeadline();
        this._id = base.getId();
        this._name = base.getName();
        this._networkTopologyRef = base.getNetworkTopologyRef();
        this._node = base.getNode();
        this._preconditions = base.getPreconditions();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link SubmitInstructionInput}</li>
     *   <li>{@link LspId}</li>
     *   <li>{@link NetworkTopologyReference}</li>
     *   <li>{@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.NodeId}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof SubmitInstructionInput castArg) {
            this._id = castArg.getId();
            this._deadline = castArg.getDeadline();
            this._preconditions = castArg.getPreconditions();
            isValidArg = true;
        }
        if (arg instanceof LspId castArg) {
            this._name = castArg.getName();
            isValidArg = true;
        }
        if (arg instanceof NetworkTopologyReference castArg) {
            this._networkTopologyRef = castArg.getNetworkTopologyRef();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.NodeId castArg) {
            this._node = castArg.getNode();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SubmitInstructionInput, LspId, NetworkTopologyReference, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.NodeId]");
    }


    /**
     * Return current value associated with the property corresponding to {@link SubmitRemoveLspInput#getDeadline()}.
     *
     * @return current value
     */
    public Nanotime getDeadline() {
        return _deadline;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SubmitRemoveLspInput#getId()}.
     *
     * @return current value
     */
    public InstructionId getId() {
        return _id;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SubmitRemoveLspInput#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SubmitRemoveLspInput#getNetworkTopologyRef()}.
     *
     * @return current value
     */
    public NetworkTopologyRef getNetworkTopologyRef() {
        return _networkTopologyRef;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SubmitRemoveLspInput#getNode()}.
     *
     * @return current value
     */
    public NodeId getNode() {
        return _node;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SubmitRemoveLspInput#getPreconditions()}.
     *
     * @return current value
     */
    public Set<InstructionId> getPreconditions() {
        return _preconditions;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SubmitRemoveLspInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link SubmitRemoveLspInput#getDeadline()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SubmitRemoveLspInputBuilder setDeadline(final Nanotime value) {
        this._deadline = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SubmitRemoveLspInput#getId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SubmitRemoveLspInputBuilder setId(final InstructionId value) {
        this._id = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SubmitRemoveLspInput#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SubmitRemoveLspInputBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SubmitRemoveLspInput#getNetworkTopologyRef()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SubmitRemoveLspInputBuilder setNetworkTopologyRef(final NetworkTopologyRef value) {
        this._networkTopologyRef = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SubmitRemoveLspInput#getNode()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SubmitRemoveLspInputBuilder setNode(final NodeId value) {
        this._node = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SubmitRemoveLspInput#getPreconditions()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public SubmitRemoveLspInputBuilder setPreconditions(final Set<InstructionId> values) {
        this._preconditions = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SubmitRemoveLspInputBuilder addAugmentation(Augmentation<SubmitRemoveLspInput> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SubmitRemoveLspInputBuilder removeAugmentation(Class<? extends Augmentation<SubmitRemoveLspInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link SubmitRemoveLspInput} instance.
     *
     * @return A new {@link SubmitRemoveLspInput} instance.
     */
    public @NonNull SubmitRemoveLspInput build() {
        return new SubmitRemoveLspInputImpl(this);
    }

    private static final class SubmitRemoveLspInputImpl
        extends AbstractAugmentable<SubmitRemoveLspInput>
        implements SubmitRemoveLspInput {
    
        private final Nanotime _deadline;
        private final InstructionId _id;
        private final String _name;
        private final NetworkTopologyRef _networkTopologyRef;
        private final NodeId _node;
        private final Set<InstructionId> _preconditions;
    
        SubmitRemoveLspInputImpl(final SubmitRemoveLspInputBuilder base) {
            super(base.augmentation);
            this._deadline = base.getDeadline();
            this._id = base.getId();
            this._name = base.getName();
            this._networkTopologyRef = base.getNetworkTopologyRef();
            this._node = base.getNode();
            this._preconditions = base.getPreconditions();
        }
    
        @Override
        public Nanotime getDeadline() {
            return _deadline;
        }
        
        @Override
        public InstructionId getId() {
            return _id;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public NetworkTopologyRef getNetworkTopologyRef() {
            return _networkTopologyRef;
        }
        
        @Override
        public NodeId getNode() {
            return _node;
        }
        
        @Override
        public Set<InstructionId> getPreconditions() {
            return _preconditions;
        }
    
        
        
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = SubmitRemoveLspInput.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return SubmitRemoveLspInput.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return SubmitRemoveLspInput.bindingToString(this);
        }
    }
}
