package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.EnumTypeObject;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-pcep</b>
 * <pre>
 * typedef failure-type {
 *   type enumeration {
 *     enum unsent {
 *     }
 *     enum no-ack {
 *     }
 *     enum failed {
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public enum FailureType implements EnumTypeObject {
    /**
     * The request failed before it was sent to the PCC.
     * PCC's state is guaranteed not to reflect state
     * transition implied by the request. This typically
     * happens if the request is syntactically invalid,
     * the target PCC is not connected or disconnects
     * while the request is enqueued.
     */
    Unsent(0, "unsent"),
    
    /**
     * The request has been sent to the PCC, but either the
     * session went down before we have received confirmation
     * of the request being received by the PCC, or the request
     * timed-out waiting for response from PCC. PCC's state is
     * unknown -- the request may or may not be reflected
     * in its internal state. The caller should not make
     * any hard assumptions about PCC state until it reconnects
     * and state synchronization completes.
     */
    NoAck(1, "no-ack"),
    
    /**
     * The request has been seen by the PCC, where it failed
     * for some external reason. The caller can assume the
     * state transition has not taken place, but is advised
     * to examine the attached error list to gain a deeper
     * understanding of the failure cause.
     */
    Failed(2, "failed")
    ;

    private final @NonNull String name;
    private final int value;

    private FailureType(int value, @NonNull String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding FailureType item, or {@code null} if no such item exists
     * @throws NullPointerException if {@code name} is null
     */
    public static @Nullable FailureType forName(String name) {
        return switch (name) {
            case "unsent" -> Unsent;
            case "no-ack" -> NoAck;
            case "failed" -> Failed;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding FailureType item, or {@code null} if no such item exists
     */
    public static @Nullable FailureType forValue(int intValue) {
        return switch (intValue) {
            case 0 -> Unsent;
            case 1 -> NoAck;
            case 2 -> Failed;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding FailureType item
     * @throws NullPointerException if {@code name} is null
     * @throws IllegalArgumentException if {@code name} does not match any item
     */
    public static @NonNull FailureType ofName(String name) {
        return CodeHelpers.checkEnum(forName(name), name);
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding FailureType item
     * @throws IllegalArgumentException if {@code intValue} does not match any item
     */
    public static @NonNull FailureType ofValue(int intValue) {
        return CodeHelpers.checkEnum(forValue(intValue), intValue);
    }
}
