package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.PcepNodeConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.pcep.node.config.SessionConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.PathComputationClient;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * Class that builds {@link Node1} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Node1 createNode1(int fooXyzzy, int barBaz) {
 *         return new Node1Builder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Node1, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Node1
 *
 */
@Generated("mdsal-binding-generator")
public class Node1Builder {

    private PathComputationClient _pathComputationClient;
    private SessionConfig _sessionConfig;



    /**
     * Construct an empty builder.
     */
    public Node1Builder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link PcepClientAttributes}.
     *
     * @param arg PcepClientAttributes from which the builder should be initialized
     */
    public Node1Builder(PcepClientAttributes arg) {
        this._pathComputationClient = arg.getPathComputationClient();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link PcepNodeConfig}.
     *
     * @param arg PcepNodeConfig from which the builder should be initialized
     */
    public Node1Builder(PcepNodeConfig arg) {
        this._sessionConfig = arg.getSessionConfig();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Node1}.
     *
     * @param base Node1 from which the builder should be initialized
     */
    public Node1Builder(final Node1 base) {
        this._pathComputationClient = base.getPathComputationClient();
        this._sessionConfig = base.getSessionConfig();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link PcepClientAttributes}</li>
     *   <li>{@link PcepNodeConfig}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof PcepClientAttributes castArg) {
            this._pathComputationClient = castArg.getPathComputationClient();
            isValidArg = true;
        }
        if (arg instanceof PcepNodeConfig castArg) {
            this._sessionConfig = castArg.getSessionConfig();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[PcepClientAttributes, PcepNodeConfig]");
    }


    /**
     * Return current value associated with the property corresponding to {@link Node1#getPathComputationClient()}.
     *
     * @return current value
     */
    public PathComputationClient getPathComputationClient() {
        return _pathComputationClient;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Node1#getSessionConfig()}.
     *
     * @return current value
     */
    public SessionConfig getSessionConfig() {
        return _sessionConfig;
    }

    
    /**
     * Set the property corresponding to {@link Node1#getPathComputationClient()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Node1Builder setPathComputationClient(final PathComputationClient value) {
        this._pathComputationClient = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Node1#getSessionConfig()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Node1Builder setSessionConfig(final SessionConfig value) {
        this._sessionConfig = value;
        return this;
    }
    

    /**
     * A new {@link Node1} instance.
     *
     * @return A new {@link Node1} instance.
     */
    public @NonNull Node1 build() {
        return new Node1Impl(this);
    }

    private static final class Node1Impl
        implements Node1 {
    
        private final PathComputationClient _pathComputationClient;
        private final SessionConfig _sessionConfig;
    
        Node1Impl(final Node1Builder base) {
            this._pathComputationClient = base.getPathComputationClient();
            this._sessionConfig = base.getSessionConfig();
        }
    
        @Override
        public PathComputationClient getPathComputationClient() {
            return _pathComputationClient;
        }
        
        @Override
        public SessionConfig getSessionConfig() {
            return _sessionConfig;
        }
    
        @Override
        public PathComputationClient nonnullPathComputationClient() {
            return Objects.requireNonNullElse(getPathComputationClient(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.PathComputationClientBuilder.empty());
        }
        
        @Override
        public SessionConfig nonnullSessionConfig() {
            return Objects.requireNonNullElse(getSessionConfig(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.pcep.node.config.SessionConfigBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Node1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Node1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Node1.bindingToString(this);
        }
    }
}
