package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.operation.result.Error;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-pcep</b>
 * <pre>
 * grouping operation-result {
 *   leaf failure {
 *     type failure-type;
 *   }
 *   list error {
 *     when "../failure = failed";
 *     uses pcep:pcep-error-object;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OperationResult
    extends
    Grouping
{




    /**
     * Return failure, or {@code null} if it is not present.
     *
     * @return {@code FailureType} failure, or {@code null} if it is not present.
     *
     */
    FailureType getFailure();
    
    /**
     * Return failure, guaranteed to be non-null.
     *
     * @return {@code FailureType} failure, guaranteed to be non-null.
     * @throws NoSuchElementException if failure is not present
     *
     */
    default @NonNull FailureType requireFailure() {
        return CodeHelpers.require(getFailure(), "failure");
    }
    
    /**
     * Return error, or {@code null} if it is not present.
     *
     * @return {@code List<Error>} error, or {@code null} if it is not present.
     *
     */
    @Nullable List<Error> getError();
    
    /**
     * Return error, or an empty list if it is not present.
     *
     * @return {@code List<Error>} error, or an empty list if it is not present.
     *
     */
    default @NonNull List<Error> nonnullError() {
        return CodeHelpers.nonnull(getError());
    }

}

