package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.PathComputationClient;
import org.opendaylight.yangtools.binding.Grouping;

/**
 * Data present in a node which is a PCEP client (PCC).
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-pcep</b>
 * <pre>
 * grouping pcep-client-attributes {
 *   container path-computation-client {
 *     config false;
 *     leaf ip-address {
 *       type inet:ip-address-no-zone;
 *     }
 *     container stateful-tlv;
 *     leaf state-sync {
 *       type pcc-sync-state;
 *       when ../stateful-tlv;
 *     }
 *     list reported-lsp {
 *       leaf name {
 *         type string;
 *       }
 *       key name;
 *       list path {
 *         leaf lsp-id {
 *           type rsvp:lsp-id;
 *         }
 *         key lsp-id;
 *         uses pcep:path-definition;
 *       }
 *       uses lsp-metadata;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface PcepClientAttributes
    extends
    Grouping
{




    /**
     * Return pathComputationClient, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         PCC-related run-time information. This container is only present when the node
     *         is connected through PCEP in a PCC role.
     *     </code>
     * </pre>
     *
     * @return {@code PathComputationClient} pathComputationClient, or {@code null} if it is not present.
     *
     */
    PathComputationClient getPathComputationClient();
    
    /**
     * Return pathComputationClient, or an empty instance if it is not present.
     *
     * @return {@code PathComputationClient} pathComputationClient, or an empty instance if it is not present.
     *
     */
    @NonNull PathComputationClient nonnullPathComputationClient();

}

