package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.operation.result.Error;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * Class that builds {@link UpdateLspOutput} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     UpdateLspOutput createUpdateLspOutput(int fooXyzzy, int barBaz) {
 *         return new UpdateLspOutputBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of UpdateLspOutput, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see UpdateLspOutput
 *
 */
@Generated("mdsal-binding-generator")
public class UpdateLspOutputBuilder {

    private List<Error> _error;
    private FailureType _failure;


    Map<Class<? extends Augmentation<UpdateLspOutput>>, Augmentation<UpdateLspOutput>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public UpdateLspOutputBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link OperationResult}.
     *
     * @param arg OperationResult from which the builder should be initialized
     */
    public UpdateLspOutputBuilder(OperationResult arg) {
        this._failure = arg.getFailure();
        this._error = arg.getError();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link UpdateLspOutput}.
     *
     * @param base UpdateLspOutput from which the builder should be initialized
     */
    public UpdateLspOutputBuilder(final UpdateLspOutput base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._error = base.getError();
        this._failure = base.getFailure();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link OperationResult}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof OperationResult castArg) {
            this._failure = castArg.getFailure();
            this._error = castArg.getError();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[OperationResult]");
    }


    /**
     * Return current value associated with the property corresponding to {@link UpdateLspOutput#getError()}.
     *
     * @return current value
     */
    public List<Error> getError() {
        return _error;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link UpdateLspOutput#getFailure()}.
     *
     * @return current value
     */
    public FailureType getFailure() {
        return _failure;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<UpdateLspOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link UpdateLspOutput#getError()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public UpdateLspOutputBuilder setError(final List<Error> values) {
        this._error = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link UpdateLspOutput#getFailure()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UpdateLspOutputBuilder setFailure(final FailureType value) {
        this._failure = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public UpdateLspOutputBuilder addAugmentation(Augmentation<UpdateLspOutput> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public UpdateLspOutputBuilder removeAugmentation(Class<? extends Augmentation<UpdateLspOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link UpdateLspOutput} instance.
     *
     * @return A new {@link UpdateLspOutput} instance.
     */
    public @NonNull UpdateLspOutput build() {
        return new UpdateLspOutputImpl(this);
    }

    private static final class UpdateLspOutputImpl
        extends AbstractAugmentable<UpdateLspOutput>
        implements UpdateLspOutput {
    
        private final List<Error> _error;
        private final FailureType _failure;
    
        UpdateLspOutputImpl(final UpdateLspOutputBuilder base) {
            super(base.augmentation);
            this._error = CodeHelpers.emptyToNull(base.getError());
            this._failure = base.getFailure();
        }
    
        @Override
        public List<Error> getError() {
            return _error;
        }
        
        @Override
        public FailureType getFailure() {
            return _failure;
        }
    
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = UpdateLspOutput.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return UpdateLspOutput.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return UpdateLspOutput.bindingToString(this);
        }
    }
}
