package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.network.topology.topology.topology.types;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.PcepConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.TopologyTypes1;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.YangModuleInfoImpl;
import org.opendaylight.yangtools.binding.Augmentable;
import org.opendaylight.yangtools.binding.ChildOf;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-pcep</b>
 * <pre>
 * container topology-pcep {
 *   presence "indicates a PCEP-aware topology";
 *   leaf ted-name {
 *     type leafref {
 *       path /nt:network-topology/nt:topology/nt:topology-id;
 *     }
 *   }
 *   uses pdc:pcep-config;
 * }
 * </pre>
 * <p>To create instances of this class use {@link TopologyPcepBuilder}.
 * @see TopologyPcepBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface TopologyPcep
    extends
    ChildOf<TopologyTypes1>,
    Augmentable<TopologyPcep>,
    PcepConfig
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("topology-pcep");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.network.topology.topology.topology.types.TopologyPcep> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.network.topology.topology.topology.types.TopologyPcep.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.network.topology.topology.topology.types.@NonNull TopologyPcep obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getSessionConfig());
        result = prime * result + Objects.hashCode(obj.getTedName());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.network.topology.topology.topology.types.@NonNull TopologyPcep thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.network.topology.topology.topology.types.TopologyPcep.class, obj);
        return other != null
            && Objects.equals(thisObj.getTedName(), other.getTedName())
            && Objects.equals(thisObj.getSessionConfig(), other.getSessionConfig())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.network.topology.topology.topology.types.@NonNull TopologyPcep obj) {
        final var helper = MoreObjects.toStringHelper("TopologyPcep");
        CodeHelpers.appendValue(helper, "sessionConfig", obj.getSessionConfig());
        CodeHelpers.appendValue(helper, "tedName", obj.getTedName());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return tedName, or {@code null} if it is not present.
     *
     * @return {@code TopologyId} tedName, or {@code null} if it is not present.
     *
     */
    TopologyId getTedName();
    
    /**
     * Return tedName, guaranteed to be non-null.
     *
     * @return {@code TopologyId} tedName, guaranteed to be non-null.
     * @throws NoSuchElementException if tedName is not present
     *
     */
    default @NonNull TopologyId requireTedName() {
        return CodeHelpers.require(getTedName(), "tedname");
    }

}

