package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.network.topology.topology.topology.types;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.PcepConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.pcep.config.SessionConfig;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * Class that builds {@link TopologyPcep} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     TopologyPcep createTopologyPcep(int fooXyzzy, int barBaz) {
 *         return new TopologyPcepBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of TopologyPcep, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see TopologyPcep
 *
 */
@Generated("mdsal-binding-generator")
public class TopologyPcepBuilder {

    private SessionConfig _sessionConfig;
    private TopologyId _tedName;


    Map<Class<? extends Augmentation<TopologyPcep>>, Augmentation<TopologyPcep>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public TopologyPcepBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link PcepConfig}.
     *
     * @param arg PcepConfig from which the builder should be initialized
     */
    public TopologyPcepBuilder(PcepConfig arg) {
        this._sessionConfig = arg.getSessionConfig();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link TopologyPcep}.
     *
     * @param base TopologyPcep from which the builder should be initialized
     */
    public TopologyPcepBuilder(final TopologyPcep base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._sessionConfig = base.getSessionConfig();
        this._tedName = base.getTedName();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link PcepConfig}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof PcepConfig castArg) {
            this._sessionConfig = castArg.getSessionConfig();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[PcepConfig]");
    }


    /**
     * Return current value associated with the property corresponding to {@link TopologyPcep#getSessionConfig()}.
     *
     * @return current value
     */
    public SessionConfig getSessionConfig() {
        return _sessionConfig;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link TopologyPcep#getTedName()}.
     *
     * @return current value
     */
    public TopologyId getTedName() {
        return _tedName;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<TopologyPcep>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link TopologyPcep#getSessionConfig()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TopologyPcepBuilder setSessionConfig(final SessionConfig value) {
        this._sessionConfig = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link TopologyPcep#getTedName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TopologyPcepBuilder setTedName(final TopologyId value) {
        this._tedName = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public TopologyPcepBuilder addAugmentation(Augmentation<TopologyPcep> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public TopologyPcepBuilder removeAugmentation(Class<? extends Augmentation<TopologyPcep>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link TopologyPcep} instance.
     *
     * @return A new {@link TopologyPcep} instance.
     */
    public @NonNull TopologyPcep build() {
        return new TopologyPcepImpl(this);
    }

    private static final class TopologyPcepImpl
        extends AbstractAugmentable<TopologyPcep>
        implements TopologyPcep {
    
        private final SessionConfig _sessionConfig;
        private final TopologyId _tedName;
    
        TopologyPcepImpl(final TopologyPcepBuilder base) {
            super(base.augmentation);
            this._sessionConfig = base.getSessionConfig();
            this._tedName = base.getTedName();
        }
    
        @Override
        public SessionConfig getSessionConfig() {
            return _sessionConfig;
        }
        
        @Override
        public TopologyId getTedName() {
            return _tedName;
        }
    
        @Override
        public SessionConfig nonnullSessionConfig() {
            return Objects.requireNonNullElse(getSessionConfig(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.pcep.config.SessionConfigBuilder.empty());
        }
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = TopologyPcep.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return TopologyPcep.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return TopologyPcep.bindingToString(this);
        }
    }
}
