package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.operation.result;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.PcepErrorObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.ErrorObject;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * Class that builds {@link Error} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Error createError(int fooXyzzy, int barBaz) {
 *         return new ErrorBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Error, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Error
 *
 */
@Generated("mdsal-binding-generator")
public class ErrorBuilder {

    private ErrorObject _errorObject;


    Map<Class<? extends Augmentation<Error>>, Augmentation<Error>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ErrorBuilder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link PcepErrorObject}.
     *
     * @param arg PcepErrorObject from which the builder should be initialized
     */
    public ErrorBuilder(PcepErrorObject arg) {
        this._errorObject = arg.getErrorObject();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link Error}.
     *
     * @param base Error from which the builder should be initialized
     */
    public ErrorBuilder(final Error base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._errorObject = base.getErrorObject();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link PcepErrorObject}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof PcepErrorObject castArg) {
            this._errorObject = castArg.getErrorObject();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[PcepErrorObject]");
    }


    /**
     * Return current value associated with the property corresponding to {@link Error#getErrorObject()}.
     *
     * @return current value
     */
    public ErrorObject getErrorObject() {
        return _errorObject;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Error>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Error#getErrorObject()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ErrorBuilder setErrorObject(final ErrorObject value) {
        this._errorObject = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ErrorBuilder addAugmentation(Augmentation<Error> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ErrorBuilder removeAugmentation(Class<? extends Augmentation<Error>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Error} instance.
     *
     * @return A new {@link Error} instance.
     */
    public @NonNull Error build() {
        return new ErrorImpl(this);
    }

    private static final class ErrorImpl
        extends AbstractAugmentable<Error>
        implements Error {
    
        private final ErrorObject _errorObject;
    
        ErrorImpl(final ErrorBuilder base) {
            super(base.augmentation);
            this._errorObject = base.getErrorObject();
        }
    
        @Override
        public ErrorObject getErrorObject() {
            return _errorObject;
        }
    
        @Override
        public ErrorObject nonnullErrorObject() {
            return Objects.requireNonNullElse(getErrorObject(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.ErrorObjectBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Error.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Error.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Error.bindingToString(this);
        }
    }
}
