package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.PccSyncState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.PcepClientAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.path.computation.client.ReportedLsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.path.computation.client.ReportedLspKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.path.computation.client.StatefulTlv;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.YangModuleInfoImpl;
import org.opendaylight.yangtools.binding.Augmentable;
import org.opendaylight.yangtools.binding.ChildOf;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * PCC-related run-time information. This container is only present when the node 
 * is connected through PCEP in a PCC role.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-pcep</b>
 * <pre>
 * container path-computation-client {
 *   config false;
 *   leaf ip-address {
 *     type inet:ip-address-no-zone;
 *   }
 *   container stateful-tlv;
 *   leaf state-sync {
 *     type pcc-sync-state;
 *     when ../stateful-tlv;
 *   }
 *   list reported-lsp {
 *     leaf name {
 *       type string;
 *     }
 *     key name;
 *     list path {
 *       leaf lsp-id {
 *         type rsvp:lsp-id;
 *       }
 *       key lsp-id;
 *       uses pcep:path-definition;
 *     }
 *     uses lsp-metadata;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link PathComputationClientBuilder}.
 * @see PathComputationClientBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface PathComputationClient
    extends
    ChildOf<PcepClientAttributes>,
    Augmentable<PathComputationClient>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("path-computation-client");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.PathComputationClient> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.PathComputationClient.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.@NonNull PathComputationClient obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getIpAddress());
        result = prime * result + Objects.hashCode(obj.getReportedLsp());
        result = prime * result + Objects.hashCode(obj.getStateSync());
        result = prime * result + Objects.hashCode(obj.getStatefulTlv());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.@NonNull PathComputationClient thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.PathComputationClient.class, obj);
        return other != null
            && Objects.equals(thisObj.getIpAddress(), other.getIpAddress())
            && Objects.equals(thisObj.getReportedLsp(), other.getReportedLsp())
            && Objects.equals(thisObj.getStateSync(), other.getStateSync())
            && Objects.equals(thisObj.getStatefulTlv(), other.getStatefulTlv())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.@NonNull PathComputationClient obj) {
        final var helper = MoreObjects.toStringHelper("PathComputationClient");
        CodeHelpers.appendValue(helper, "ipAddress", obj.getIpAddress());
        CodeHelpers.appendValue(helper, "reportedLsp", obj.getReportedLsp());
        CodeHelpers.appendValue(helper, "stateSync", obj.getStateSync());
        CodeHelpers.appendValue(helper, "statefulTlv", obj.getStatefulTlv());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return ipAddress, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         IP address which the node used to connected to the PCE. There are no guarantees
     *         as to reachability of the address, nor its relationship to other control,
     *         management, or data plane addresses.
     *     </code>
     * </pre>
     *
     * @return {@code IpAddressNoZone} ipAddress, or {@code null} if it is not present.
     *
     */
    IpAddressNoZone getIpAddress();
    
    /**
     * Return ipAddress, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         IP address which the node used to connected to the PCE. There are no guarantees
     *         as to reachability of the address, nor its relationship to other control,
     *         management, or data plane addresses.
     *     </code>
     * </pre>
     *
     * @return {@code IpAddressNoZone} ipAddress, guaranteed to be non-null.
     * @throws NoSuchElementException if ipAddress is not present
     *
     */
    default @NonNull IpAddressNoZone requireIpAddress() {
        return CodeHelpers.require(getIpAddress(), "ipaddress");
    }
    
    /**
     * Return statefulTlv, or {@code null} if it is not present.
     *
     * @return {@code StatefulTlv} statefulTlv, or {@code null} if it is not present.
     *
     */
    StatefulTlv getStatefulTlv();
    
    /**
     * Return statefulTlv, or an empty instance if it is not present.
     *
     * @return {@code StatefulTlv} statefulTlv, or an empty instance if it is not present.
     *
     */
    @NonNull StatefulTlv nonnullStatefulTlv();
    
    /**
     * Return stateSync, or {@code null} if it is not present.
     *
     * @return {@code PccSyncState} stateSync, or {@code null} if it is not present.
     *
     */
    PccSyncState getStateSync();
    
    /**
     * Return stateSync, guaranteed to be non-null.
     *
     * @return {@code PccSyncState} stateSync, guaranteed to be non-null.
     * @throws NoSuchElementException if stateSync is not present
     *
     */
    default @NonNull PccSyncState requireStateSync() {
        return CodeHelpers.require(getStateSync(), "statesync");
    }
    
    /**
     * Return reportedLsp, or {@code null} if it is not present.
     *
     * @return {@code Map<ReportedLspKey, ReportedLsp>} reportedLsp, or {@code null} if it is not present.
     *
     */
    @Nullable Map<ReportedLspKey, ReportedLsp> getReportedLsp();
    
    /**
     * Return reportedLsp, or an empty list if it is not present.
     *
     * @return {@code Map<ReportedLspKey, ReportedLsp>} reportedLsp, or an empty list if it is not present.
     *
     */
    default @NonNull Map<ReportedLspKey, ReportedLsp> nonnullReportedLsp() {
        return CodeHelpers.nonnull(getReportedLsp());
    }

}

