package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.path.computation.client;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.LspMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.lsp.metadata.Metadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.path.computation.client.reported.lsp.Path;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.path.computation.client.reported.lsp.PathKey;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractEntryObject;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * Class that builds {@link ReportedLsp} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ReportedLsp createReportedLsp(int fooXyzzy, int barBaz) {
 *         return new ReportedLspBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ReportedLsp, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ReportedLsp
 *
 */
@Generated("mdsal-binding-generator")
public class ReportedLspBuilder {

    private Metadata _metadata;
    private String _name;
    private Map<PathKey, Path> _path;
    private ReportedLspKey key;


    Map<Class<? extends Augmentation<ReportedLsp>>, Augmentation<ReportedLsp>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ReportedLspBuilder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link LspMetadata}.
     *
     * @param arg LspMetadata from which the builder should be initialized
     */
    public ReportedLspBuilder(LspMetadata arg) {
        this._metadata = arg.getMetadata();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link ReportedLsp}.
     *
     * @param base ReportedLsp from which the builder should be initialized
     */
    public ReportedLspBuilder(final ReportedLsp base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._metadata = base.getMetadata();
        this._path = base.getPath();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link LspMetadata}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof LspMetadata castArg) {
            this._metadata = castArg.getMetadata();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[LspMetadata]");
    }


    /**
     * Return current value associated with the property corresponding to {@link ReportedLsp#key()}.
     *
     * @return current value
     */
    public ReportedLspKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ReportedLsp#getMetadata()}.
     *
     * @return current value
     */
    public Metadata getMetadata() {
        return _metadata;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ReportedLsp#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ReportedLsp#getPath()}.
     *
     * @return current value
     */
    public Map<PathKey, Path> getPath() {
        return _path;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ReportedLsp>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link ReportedLsp#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public ReportedLspBuilder withKey(final ReportedLspKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ReportedLsp#getMetadata()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ReportedLspBuilder setMetadata(final Metadata value) {
        this._metadata = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ReportedLsp#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ReportedLspBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ReportedLsp#getPath()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public ReportedLspBuilder setPath(final Map<PathKey, Path> values) {
        this._path = values;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ReportedLspBuilder addAugmentation(Augmentation<ReportedLsp> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ReportedLspBuilder removeAugmentation(Class<? extends Augmentation<ReportedLsp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link ReportedLsp} instance.
     *
     * @return A new {@link ReportedLsp} instance.
     */
    public @NonNull ReportedLsp build() {
        return new ReportedLspImpl(this);
    }

    private static final class ReportedLspImpl
        extends AbstractEntryObject<ReportedLsp, ReportedLspKey>
        implements ReportedLsp {
    
        private final Metadata _metadata;
        private final String _name;
        private final Map<PathKey, Path> _path;
    
        ReportedLspImpl(final ReportedLspBuilder base) {
            super(base.augmentation, extractKey(base));
            final var key = key();
            this._name = key.getName();
            this._metadata = base.getMetadata();
            this._path = CodeHelpers.emptyToNull(base.getPath());
        }
        
        private static @NonNull ReportedLspKey extractKey(final ReportedLspBuilder base) {
            final var key = base.key();
            return key != null ? key
                : new ReportedLspKey(base.getName());
        }
    
        @Override
        public Metadata getMetadata() {
            return _metadata;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public Map<PathKey, Path> getPath() {
            return _path;
        }
    
        @Override
        public Metadata nonnullMetadata() {
            return Objects.requireNonNullElse(getMetadata(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.lsp.metadata.MetadataBuilder.empty());
        }
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ReportedLsp.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ReportedLsp.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ReportedLsp.bindingToString(this);
        }
    }
}
