package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.path.computation.client.reported.lsp;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LspId;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * This class represents the key of {@link Path} class.
 *
 * @see Path
 *
 */
@Generated("mdsal-binding-generator")
public final class PathKey
 implements Key<Path> {
    @java.io.Serial
    private static final long serialVersionUID = 710357445099471264L;
    private final LspId _lspId;


    /**
     * Constructs an instance.
     *
     * @param _lspId the entity lspId
     * @throws NullPointerException if any of the arguments are null
     */
    public PathKey(@NonNull LspId _lspId) {
        this._lspId = CodeHelpers.requireKeyProp(_lspId, "lspId");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public PathKey(PathKey source) {
        this._lspId = source._lspId;
    }


    /**
     * Return lspId, guaranteed to be non-null.
     *
     * @return {@code LspId} lspId, guaranteed to be non-null.
     */
    public @NonNull LspId getLspId() {
        return _lspId;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_lspId);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof PathKey other
            && Objects.equals(_lspId, other._lspId);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(PathKey.class);
        CodeHelpers.appendValue(helper, "lspId", _lspId);
        return helper.toString();
    }
}

