/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.programming.rev131106;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev130930.InstructionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev130930.Nanotime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev130930.SubmitInstructionInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.programming.rev131106.SubmitRemoveLspInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.LspId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SubmitRemoveLspInputBuilder
implements Builder<SubmitRemoveLspInput> {
    private Nanotime _deadline;
    private InstructionId _id;
    private String _name;
    private NetworkTopologyRef _networkTopologyRef;
    private NodeId _node;
    private List<InstructionId> _preconditions;
    Map<Class<? extends Augmentation<SubmitRemoveLspInput>>, Augmentation<SubmitRemoveLspInput>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKDEADLINERANGE_RANGES;

    public SubmitRemoveLspInputBuilder() {
    }

    public SubmitRemoveLspInputBuilder(SubmitInstructionInput arg) {
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
    }

    public SubmitRemoveLspInputBuilder(NetworkTopologyReference arg) {
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }

    public SubmitRemoveLspInputBuilder(LspId arg) {
        this._node = arg.getNode();
        this._name = arg.getName();
    }

    public SubmitRemoveLspInputBuilder(SubmitRemoveLspInput base) {
        AugmentationHolder casted;
        this._deadline = base.getDeadline();
        this._id = base.getId();
        this._name = base.getName();
        this._networkTopologyRef = base.getNetworkTopologyRef();
        this._node = base.getNode();
        this._preconditions = base.getPreconditions();
        if (base instanceof SubmitRemoveLspInputImpl) {
            SubmitRemoveLspInputImpl impl = (SubmitRemoveLspInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SubmitRemoveLspInput>>, Augmentation<SubmitRemoveLspInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SubmitRemoveLspInput>>, Augmentation<SubmitRemoveLspInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NetworkTopologyReference) {
            this._networkTopologyRef = ((NetworkTopologyReference)arg).getNetworkTopologyRef();
            isValidArg = true;
        }
        if (arg instanceof LspId) {
            this._node = ((LspId)arg).getNode();
            this._name = ((LspId)arg).getName();
            isValidArg = true;
        }
        if (arg instanceof SubmitInstructionInput) {
            this._id = ((SubmitInstructionInput)arg).getId();
            this._deadline = ((SubmitInstructionInput)arg).getDeadline();
            this._preconditions = ((SubmitInstructionInput)arg).getPreconditions();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.LspId, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev130930.SubmitInstructionInput] \nbut was: " + arg);
        }
    }

    public Nanotime getDeadline() {
        return this._deadline;
    }

    public InstructionId getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public NetworkTopologyRef getNetworkTopologyRef() {
        return this._networkTopologyRef;
    }

    public NodeId getNode() {
        return this._node;
    }

    public List<InstructionId> getPreconditions() {
        return this._preconditions;
    }

    public <E extends Augmentation<SubmitRemoveLspInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkDeadlineRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKDEADLINERANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKDEADLINERANGE_RANGES)));
    }

    public SubmitRemoveLspInputBuilder setDeadline(Nanotime value) {
        if (value != null) {
            SubmitRemoveLspInputBuilder.checkDeadlineRange(value.getValue());
        }
        this._deadline = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _deadline_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615")));
        return ret;
    }

    public SubmitRemoveLspInputBuilder setId(InstructionId value) {
        if (value != null) {
            // empty if block
        }
        this._id = value;
        return this;
    }

    public SubmitRemoveLspInputBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public SubmitRemoveLspInputBuilder setNetworkTopologyRef(NetworkTopologyRef value) {
        if (value != null) {
            // empty if block
        }
        this._networkTopologyRef = value;
        return this;
    }

    public SubmitRemoveLspInputBuilder setNode(NodeId value) {
        if (value != null) {
            // empty if block
        }
        this._node = value;
        return this;
    }

    public SubmitRemoveLspInputBuilder setPreconditions(List<InstructionId> value) {
        this._preconditions = value;
        return this;
    }

    public SubmitRemoveLspInputBuilder addAugmentation(Class<? extends Augmentation<SubmitRemoveLspInput>> augmentationType, Augmentation<SubmitRemoveLspInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SubmitRemoveLspInput>>, Augmentation<SubmitRemoveLspInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SubmitRemoveLspInputBuilder removeAugmentation(Class<? extends Augmentation<SubmitRemoveLspInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SubmitRemoveLspInput build() {
        return new SubmitRemoveLspInputImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKDEADLINERANGE_RANGES = a;
    }

    private static final class SubmitRemoveLspInputImpl
    implements SubmitRemoveLspInput {
        private final Nanotime _deadline;
        private final InstructionId _id;
        private final String _name;
        private final NetworkTopologyRef _networkTopologyRef;
        private final NodeId _node;
        private final List<InstructionId> _preconditions;
        private Map<Class<? extends Augmentation<SubmitRemoveLspInput>>, Augmentation<SubmitRemoveLspInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SubmitRemoveLspInput> getImplementedInterface() {
            return SubmitRemoveLspInput.class;
        }

        private SubmitRemoveLspInputImpl(SubmitRemoveLspInputBuilder base) {
            this._deadline = base.getDeadline();
            this._id = base.getId();
            this._name = base.getName();
            this._networkTopologyRef = base.getNetworkTopologyRef();
            this._node = base.getNode();
            this._preconditions = base.getPreconditions();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SubmitRemoveLspInput>>, Augmentation<SubmitRemoveLspInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SubmitRemoveLspInput>>, Augmentation<SubmitRemoveLspInput>>(base.augmentation);
                }
            }
        }

        public Nanotime getDeadline() {
            return this._deadline;
        }

        public InstructionId getId() {
            return this._id;
        }

        @Override
        public String getName() {
            return this._name;
        }

        public NetworkTopologyRef getNetworkTopologyRef() {
            return this._networkTopologyRef;
        }

        @Override
        public NodeId getNode() {
            return this._node;
        }

        public List<InstructionId> getPreconditions() {
            return this._preconditions;
        }

        public <E extends Augmentation<SubmitRemoveLspInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._deadline == null ? 0 : this._deadline.hashCode());
            result = 31 * result + (this._id == null ? 0 : this._id.hashCode());
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            result = 31 * result + (this._networkTopologyRef == null ? 0 : this._networkTopologyRef.hashCode());
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this._preconditions == null ? 0 : this._preconditions.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SubmitRemoveLspInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SubmitRemoveLspInput other = (SubmitRemoveLspInput)obj;
            if (this._deadline == null ? other.getDeadline() != null : !this._deadline.equals((Object)other.getDeadline())) {
                return false;
            }
            if (this._id == null ? other.getId() != null : !this._id.equals((Object)other.getId())) {
                return false;
            }
            if (this._name == null ? other.getName() != null : !this._name.equals(other.getName())) {
                return false;
            }
            if (this._networkTopologyRef == null ? other.getNetworkTopologyRef() != null : !this._networkTopologyRef.equals((Object)other.getNetworkTopologyRef())) {
                return false;
            }
            if (this._node == null ? other.getNode() != null : !this._node.equals((Object)other.getNode())) {
                return false;
            }
            if (this._preconditions == null ? other.getPreconditions() != null : !this._preconditions.equals(other.getPreconditions())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SubmitRemoveLspInputImpl otherImpl = (SubmitRemoveLspInputImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SubmitRemoveLspInput>>, Augmentation<SubmitRemoveLspInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("SubmitRemoveLspInput [");
            boolean first = true;
            if (this._deadline != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_deadline=");
                builder.append(this._deadline);
            }
            if (this._id != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_id=");
                builder.append(this._id);
            }
            if (this._name != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_name=");
                builder.append(this._name);
            }
            if (this._networkTopologyRef != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_networkTopologyRef=");
                builder.append(this._networkTopologyRef);
            }
            if (this._node != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_node=");
                builder.append(this._node);
            }
            if (this._preconditions != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_preconditions=");
                builder.append(this._preconditions);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

