/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.ensure.lsp.operational.args;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.ensure.lsp.operational.args.Arguments;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ArgumentsBuilder
implements Builder<Arguments> {
    Map<Class<? extends Augmentation<Arguments>>, Augmentation<Arguments>> augmentation = Collections.emptyMap();

    public ArgumentsBuilder() {
    }

    public ArgumentsBuilder(Arguments base) {
        AugmentationHolder casted;
        if (base instanceof ArgumentsImpl) {
            ArgumentsImpl impl = (ArgumentsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Arguments>>, Augmentation<Arguments>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Arguments>>, Augmentation<Arguments>>(casted.augmentations());
        }
    }

    public <E extends Augmentation<Arguments>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ArgumentsBuilder addAugmentation(Class<? extends Augmentation<Arguments>> augmentationType, Augmentation<Arguments> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Arguments>>, Augmentation<Arguments>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ArgumentsBuilder removeAugmentation(Class<? extends Augmentation<Arguments>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Arguments build() {
        return new ArgumentsImpl(this);
    }

    private static final class ArgumentsImpl
    implements Arguments {
        private Map<Class<? extends Augmentation<Arguments>>, Augmentation<Arguments>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Arguments> getImplementedInterface() {
            return Arguments.class;
        }

        private ArgumentsImpl(ArgumentsBuilder base) {
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Arguments>>, Augmentation<Arguments>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Arguments>>, Augmentation<Arguments>>(base.augmentation);
                }
            }
        }

        public <E extends Augmentation<Arguments>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Arguments.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Arguments other = (Arguments)obj;
            if (this.getClass() == obj.getClass()) {
                ArgumentsImpl otherImpl = (ArgumentsImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Arguments>>, Augmentation<Arguments>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Arguments [");
            boolean first = true;
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

