/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.pcep.client.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.PccSyncState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.pcep.client.attributes.PathComputationClient;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.pcep.client.attributes.path.computation.client.ReportedLsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.pcep.client.attributes.path.computation.client.StatefulTlv;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PathComputationClientBuilder
implements Builder<PathComputationClient> {
    private IpAddress _ipAddress;
    private List<ReportedLsp> _reportedLsp;
    private PccSyncState _stateSync;
    private StatefulTlv _statefulTlv;
    Map<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>> augmentation = Collections.emptyMap();

    public PathComputationClientBuilder() {
    }

    public PathComputationClientBuilder(PathComputationClient base) {
        AugmentationHolder casted;
        this._ipAddress = base.getIpAddress();
        this._reportedLsp = base.getReportedLsp();
        this._stateSync = base.getStateSync();
        this._statefulTlv = base.getStatefulTlv();
        if (base instanceof PathComputationClientImpl) {
            PathComputationClientImpl impl = (PathComputationClientImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>>(casted.augmentations());
        }
    }

    public IpAddress getIpAddress() {
        return this._ipAddress;
    }

    public List<ReportedLsp> getReportedLsp() {
        return this._reportedLsp;
    }

    public PccSyncState getStateSync() {
        return this._stateSync;
    }

    public StatefulTlv getStatefulTlv() {
        return this._statefulTlv;
    }

    public <E extends Augmentation<PathComputationClient>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PathComputationClientBuilder setIpAddress(IpAddress value) {
        if (value != null) {
            // empty if block
        }
        this._ipAddress = value;
        return this;
    }

    public PathComputationClientBuilder setReportedLsp(List<ReportedLsp> value) {
        this._reportedLsp = value;
        return this;
    }

    public PathComputationClientBuilder setStateSync(PccSyncState value) {
        this._stateSync = value;
        return this;
    }

    public PathComputationClientBuilder setStatefulTlv(StatefulTlv value) {
        this._statefulTlv = value;
        return this;
    }

    public PathComputationClientBuilder addAugmentation(Class<? extends Augmentation<PathComputationClient>> augmentationType, Augmentation<PathComputationClient> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PathComputationClientBuilder removeAugmentation(Class<? extends Augmentation<PathComputationClient>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PathComputationClient build() {
        return new PathComputationClientImpl(this);
    }

    private static final class PathComputationClientImpl
    implements PathComputationClient {
        private final IpAddress _ipAddress;
        private final List<ReportedLsp> _reportedLsp;
        private final PccSyncState _stateSync;
        private final StatefulTlv _statefulTlv;
        private Map<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PathComputationClient> getImplementedInterface() {
            return PathComputationClient.class;
        }

        private PathComputationClientImpl(PathComputationClientBuilder base) {
            this._ipAddress = base.getIpAddress();
            this._reportedLsp = base.getReportedLsp();
            this._stateSync = base.getStateSync();
            this._statefulTlv = base.getStatefulTlv();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>>(base.augmentation);
                }
            }
        }

        @Override
        public IpAddress getIpAddress() {
            return this._ipAddress;
        }

        @Override
        public List<ReportedLsp> getReportedLsp() {
            return this._reportedLsp;
        }

        @Override
        public PccSyncState getStateSync() {
            return this._stateSync;
        }

        @Override
        public StatefulTlv getStatefulTlv() {
            return this._statefulTlv;
        }

        public <E extends Augmentation<PathComputationClient>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._ipAddress == null ? 0 : this._ipAddress.hashCode());
            result = 31 * result + (this._reportedLsp == null ? 0 : this._reportedLsp.hashCode());
            result = 31 * result + (this._stateSync == null ? 0 : this._stateSync.hashCode());
            result = 31 * result + (this._statefulTlv == null ? 0 : this._statefulTlv.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PathComputationClient.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PathComputationClient other = (PathComputationClient)obj;
            if (this._ipAddress == null ? other.getIpAddress() != null : !this._ipAddress.equals((Object)other.getIpAddress())) {
                return false;
            }
            if (this._reportedLsp == null ? other.getReportedLsp() != null : !this._reportedLsp.equals(other.getReportedLsp())) {
                return false;
            }
            if (this._stateSync == null ? other.getStateSync() != null : !this._stateSync.equals((Object)other.getStateSync())) {
                return false;
            }
            if (this._statefulTlv == null ? other.getStatefulTlv() != null : !this._statefulTlv.equals(other.getStatefulTlv())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PathComputationClientImpl otherImpl = (PathComputationClientImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PathComputationClient [");
            boolean first = true;
            if (this._ipAddress != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ipAddress=");
                builder.append(this._ipAddress);
            }
            if (this._reportedLsp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_reportedLsp=");
                builder.append(this._reportedLsp);
            }
            if (this._stateSync != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_stateSync=");
                builder.append((Object)this._stateSync);
            }
            if (this._statefulTlv != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_statefulTlv=");
                builder.append(this._statefulTlv);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

