package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.programming.rev131106;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.EnsureLspOperationalArgs;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.programming.rev131102.TopologyInstructionInput;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>network-topology-pcep-programming</b>
 * <pre>
 * container input {
 *     leaf network-topology-ref {
 *         type network-topology-ref;
 *     }
 *     leaf id {
 *         type instruction-id;
 *     }
 *     leaf deadline {
 *         type nanotime;
 *     }
 *     leaf-list preconditions {
 *         type instruction-id;
 *     }
 *     container arguments {
 *     }
 *     leaf node {
 *         type node-ref;
 *     }
 *     leaf name {
 *         type string;
 *     }
 *     uses ensure-lsp-operational-args;
 *     uses topology-instruction-input;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>network-topology-pcep-programming/submit-ensure-lsp-operational/input</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.programming.rev131106.SubmitEnsureLspOperationalInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.programming.rev131106.SubmitEnsureLspOperationalInputBuilder
 *
 */
public interface SubmitEnsureLspOperationalInput
    extends
    EnsureLspOperationalArgs,
    TopologyInstructionInput,
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.programming.rev131106.SubmitEnsureLspOperationalInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:pcep:programming",
        "2013-11-06", "input").intern();


}

