package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.programming.rev131106;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.programming.rev131102.TopologyInstructionOutput;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>network-topology-pcep-programming</b>
 * <pre>
 * container output {
 *     choice result {
 *         case failure-case {
 *             container failure {
 *                 leaf type {
 *                     type identityref;
 *                 }
 *                 leaf-list failed-preconditions {
 *                     type instruction-id;
 *                 }
 *             }
 *         }
 *     }
 *     uses topology-instruction-output;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>network-topology-pcep-programming/submit-trigger-sync/output</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.programming.rev131106.SubmitTriggerSyncOutputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.programming.rev131106.SubmitTriggerSyncOutputBuilder
 *
 */
public interface SubmitTriggerSyncOutput
    extends
    TopologyInstructionOutput,
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.programming.rev131106.SubmitTriggerSyncOutput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:pcep:programming",
        "2013-11-06", "output").intern();


}

