package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>network-topology-pcep</b>
 * <pre>
 * container input {
 *     leaf network-topology-ref {
 *         type network-topology-ref;
 *     }
 *     container arguments {
 *         container metadata {
 *         }
 *         container endpoints-obj {
 *             choice address-family {
 *                 case ipv4-case {
 *                     container ipv4 {
 *                         leaf source-ipv4-address {
 *                             type ipv4-address;
 *                         }
 *                         leaf destination-ipv4-address {
 *                             type ipv4-address;
 *                         }
 *                     }
 *                 }
 *                 case ipv6-case {
 *                     container ipv6 {
 *                         leaf source-ipv6-address {
 *                             type ipv6-address;
 *                         }
 *                         leaf destination-ipv6-address {
 *                             type ipv6-address;
 *                         }
 *                     }
 *                 }
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *             uses endpoints;
 *         }
 *         container ero {
 *             list subobject {
 *                 key     leaf loose {
 *                     type boolean;
 *                 }
 *                 choice subobject-type {
 *                     case as-number-case {
 *                         container as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                             uses as-number-subobject;
 *                         }
 *                     }
 *                     case exrs-case {
 *                         container exrs {
 *                             list exrs {
 *                                 key     leaf mandatory {
 *                                     type mandatory;
 *                                 }
 *                                 leaf attribute {
 *                                     type enumeration;
 *                                 }
 *                                 choice subobject-type {
 *                                     case as-number-case {
 *                                         container as-number {
 *                                             leaf as-number {
 *                                                 type as-number;
 *                                             }
 *                                             uses as-number-subobject;
 *                                         }
 *                                     }
 *                                     case ip-prefix-case {
 *                                         container ip-prefix {
 *                                             leaf ip-prefix {
 *                                                 type ip-prefix;
 *                                             }
 *                                             uses ip-prefix-subobject;
 *                                         }
 *                                     }
 *                                     case label-case {
 *                                         container label {
 *                                             leaf uni-directional {
 *                                                 type boolean;
 *                                             }
 *                                             choice label-type {
 *                                                 case generalized-label-case {
 *                                                     container generalized-label {
 *                                                         leaf generalized-label {
 *                                                             type binary;
 *                                                         }
 *                                                         uses generalized-label;
 *                                                     }
 *                                                 }
 *                                                 case type1-label-case {
 *                                                     container type1-label {
 *                                                         leaf type1-label {
 *                                                             type uint32;
 *                                                         }
 *                                                         uses type1-label;
 *                                                     }
 *                                                 }
 *                                                 case waveband-switching-label-case {
 *                                                     container waveband-switching-label {
 *                                                         leaf end-label {
 *                                                             type uint32;
 *                                                         }
 *                                                         leaf start-label {
 *                                                             type uint32;
 *                                                         }
 *                                                         leaf waveband-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         uses waveband-switching-label;
 *                                                     }
 *                                                 }
 *                                             }
 *                                             uses label-subobject;
 *                                         }
 *                                     }
 *                                     case srlg-case {
 *                                         container srlg {
 *                                             leaf srlg-id {
 *                                                 type srlg-id;
 *                                             }
 *                                             uses srlg-subobject;
 *                                         }
 *                                     }
 *                                     case unnumbered-case {
 *                                         container unnumbered {
 *                                             leaf router-id {
 *                                                 type uint32;
 *                                             }
 *                                             leaf interface-id {
 *                                                 type uint32;
 *                                             }
 *                                             uses unnumbered-subobject;
 *                                         }
 *                                     }
 *                                 }
 *                                 uses exclude-route-subobjects;
 *                             }
 *                         }
 *                     }
 *                     case ip-prefix-case {
 *                         container ip-prefix {
 *                             leaf ip-prefix {
 *                                 type ip-prefix;
 *                             }
 *                             uses ip-prefix-subobject;
 *                         }
 *                     }
 *                     case label-case {
 *                         container label {
 *                             leaf uni-directional {
 *                                 type boolean;
 *                             }
 *                             choice label-type {
 *                                 case generalized-label-case {
 *                                     container generalized-label {
 *                                         leaf generalized-label {
 *                                             type binary;
 *                                         }
 *                                         uses generalized-label;
 *                                     }
 *                                 }
 *                                 case type1-label-case {
 *                                     container type1-label {
 *                                         leaf type1-label {
 *                                             type uint32;
 *                                         }
 *                                         uses type1-label;
 *                                     }
 *                                 }
 *                                 case waveband-switching-label-case {
 *                                     container waveband-switching-label {
 *                                         leaf end-label {
 *                                             type uint32;
 *                                         }
 *                                         leaf start-label {
 *                                             type uint32;
 *                                         }
 *                                         leaf waveband-id {
 *                                             type uint32;
 *                                         }
 *                                         uses waveband-switching-label;
 *                                     }
 *                                 }
 *                             }
 *                             uses label-subobject;
 *                         }
 *                     }
 *                     case path-key-case {
 *                         container path-key {
 *                             leaf pce-id {
 *                                 type pce-id;
 *                             }
 *                             leaf path-key {
 *                                 type path-key;
 *                             }
 *                             uses path-key-subobject;
 *                         }
 *                     }
 *                     case srlg-case {
 *                         container srlg {
 *                             leaf srlg-id {
 *                                 type srlg-id;
 *                             }
 *                             uses srlg-subobject;
 *                         }
 *                     }
 *                     case unnumbered-case {
 *                         container unnumbered {
 *                             leaf router-id {
 *                                 type uint32;
 *                             }
 *                             leaf interface-id {
 *                                 type uint32;
 *                             }
 *                             uses unnumbered-subobject;
 *                         }
 *                     }
 *                 }
 *                 uses explicit-route-subobjects;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         list metrics {
 *             key     container metric {
 *                 leaf metric-type {
 *                     type uint8;
 *                 }
 *                 leaf bound {
 *                     type bound;
 *                 }
 *                 leaf computed {
 *                     type computed;
 *                 }
 *                 leaf value {
 *                     type float32;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             uses metric-object;
 *         }
 *         container bandwidth {
 *             leaf bandwidth {
 *                 type bandwidth;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *             uses bandwidth;
 *         }
 *         container reoptimization-bandwidth {
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             leaf bandwidth {
 *                 type bandwidth;
 *             }
 *             uses object;
 *             uses bandwidth;
 *         }
 *         container class-type {
 *             leaf class-type {
 *                 type class-type;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         container of {
 *             leaf code {
 *                 type of-id;
 *             }
 *             container tlvs {
 *                 list vendor-information-tlv {
 *                     key     leaf enterprise-number {
 *                         type enterprise-number;
 *                     }
 *                     choice enterprise-specific-information {
 *                     }
 *                     uses vendor-information;
 *                     uses tlv;
 *                 }
 *                 uses vendor-information-tlvs;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         container rro {
 *             list subobject {
 *                 key     leaf protection-available {
 *                     type protection-available;
 *                 }
 *                 leaf protection-in-use {
 *                     type protection-in-use;
 *                 }
 *                 choice subobject-type {
 *                     case ip-prefix-case {
 *                         container ip-prefix {
 *                             leaf ip-prefix {
 *                                 type ip-prefix;
 *                             }
 *                             uses ip-prefix-subobject;
 *                         }
 *                     }
 *                     case label-case {
 *                         container label {
 *                             leaf global {
 *                                 type global;
 *                             }
 *                             leaf uni-directional {
 *                                 type boolean;
 *                             }
 *                             choice label-type {
 *                                 case generalized-label-case {
 *                                     container generalized-label {
 *                                         leaf generalized-label {
 *                                             type binary;
 *                                         }
 *                                         uses generalized-label;
 *                                     }
 *                                 }
 *                                 case type1-label-case {
 *                                     container type1-label {
 *                                         leaf type1-label {
 *                                             type uint32;
 *                                         }
 *                                         uses type1-label;
 *                                     }
 *                                 }
 *                                 case waveband-switching-label-case {
 *                                     container waveband-switching-label {
 *                                         leaf end-label {
 *                                             type uint32;
 *                                         }
 *                                         leaf start-label {
 *                                             type uint32;
 *                                         }
 *                                         leaf waveband-id {
 *                                             type uint32;
 *                                         }
 *                                         uses waveband-switching-label;
 *                                     }
 *                                 }
 *                             }
 *                             uses label-subobject;
 *                         }
 *                     }
 *                     case path-key-case {
 *                         container path-key {
 *                             leaf pce-id {
 *                                 type pce-id;
 *                             }
 *                             leaf path-key {
 *                                 type path-key;
 *                             }
 *                             uses path-key-subobject;
 *                         }
 *                     }
 *                     case unnumbered-case {
 *                         container unnumbered {
 *                             leaf router-id {
 *                                 type uint32;
 *                             }
 *                             leaf interface-id {
 *                                 type uint32;
 *                             }
 *                             uses unnumbered-subobject;
 *                         }
 *                     }
 *                 }
 *                 uses record-route-subobjects;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         container lspa {
 *             container tlvs {
 *                 list vendor-information-tlv {
 *                     key     leaf enterprise-number {
 *                         type enterprise-number;
 *                     }
 *                     choice enterprise-specific-information {
 *                     }
 *                     uses vendor-information;
 *                     uses tlv;
 *                 }
 *                 uses vendor-information-tlvs;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             leaf local-protection-desired {
 *                 type local-protection-desired;
 *             }
 *             leaf label-recording-desired {
 *                 type label-recording-desired;
 *             }
 *             leaf se-style-desired {
 *                 type se-style-desired;
 *             }
 *             leaf session-name {
 *                 type string;
 *             }
 *             leaf hold-priority {
 *                 type hold-priority;
 *             }
 *             leaf setup-priority {
 *                 type setup-priority;
 *             }
 *             leaf include-any {
 *                 type attribute-filter;
 *             }
 *             leaf exclude-any {
 *                 type attribute-filter;
 *             }
 *             leaf include-all {
 *                 type attribute-filter;
 *             }
 *             uses tunnel-attributes;
 *             uses object;
 *         }
 *         container xro {
 *             leaf flags {
 *                 type bits;
 *             }
 *             list subobject {
 *                 key     leaf mandatory {
 *                     type mandatory;
 *                 }
 *                 leaf attribute {
 *                     type enumeration;
 *                 }
 *                 choice subobject-type {
 *                     case as-number-case {
 *                         container as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                             uses as-number-subobject;
 *                         }
 *                     }
 *                     case ip-prefix-case {
 *                         container ip-prefix {
 *                             leaf ip-prefix {
 *                                 type ip-prefix;
 *                             }
 *                             uses ip-prefix-subobject;
 *                         }
 *                     }
 *                     case label-case {
 *                         container label {
 *                             leaf uni-directional {
 *                                 type boolean;
 *                             }
 *                             choice label-type {
 *                                 case generalized-label-case {
 *                                     container generalized-label {
 *                                         leaf generalized-label {
 *                                             type binary;
 *                                         }
 *                                         uses generalized-label;
 *                                     }
 *                                 }
 *                                 case type1-label-case {
 *                                     container type1-label {
 *                                         leaf type1-label {
 *                                             type uint32;
 *                                         }
 *                                         uses type1-label;
 *                                     }
 *                                 }
 *                                 case waveband-switching-label-case {
 *                                     container waveband-switching-label {
 *                                         leaf end-label {
 *                                             type uint32;
 *                                         }
 *                                         leaf start-label {
 *                                             type uint32;
 *                                         }
 *                                         leaf waveband-id {
 *                                             type uint32;
 *                                         }
 *                                         uses waveband-switching-label;
 *                                     }
 *                                 }
 *                             }
 *                             uses label-subobject;
 *                         }
 *                     }
 *                     case srlg-case {
 *                         container srlg {
 *                             leaf srlg-id {
 *                                 type srlg-id;
 *                             }
 *                             uses srlg-subobject;
 *                         }
 *                     }
 *                     case unnumbered-case {
 *                         container unnumbered {
 *                             leaf router-id {
 *                                 type uint32;
 *                             }
 *                             leaf interface-id {
 *                                 type uint32;
 *                             }
 *                             uses unnumbered-subobject;
 *                         }
 *                     }
 *                 }
 *                 uses exclude-route-subobjects;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         container iro {
 *             list subobject {
 *                 key     leaf loose {
 *                     type boolean;
 *                 }
 *                 choice subobject-type {
 *                     case as-number-case {
 *                         container as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                             uses as-number-subobject;
 *                         }
 *                     }
 *                     case exrs-case {
 *                         container exrs {
 *                             list exrs {
 *                                 key     leaf mandatory {
 *                                     type mandatory;
 *                                 }
 *                                 leaf attribute {
 *                                     type enumeration;
 *                                 }
 *                                 choice subobject-type {
 *                                     case as-number-case {
 *                                         container as-number {
 *                                             leaf as-number {
 *                                                 type as-number;
 *                                             }
 *                                             uses as-number-subobject;
 *                                         }
 *                                     }
 *                                     case ip-prefix-case {
 *                                         container ip-prefix {
 *                                             leaf ip-prefix {
 *                                                 type ip-prefix;
 *                                             }
 *                                             uses ip-prefix-subobject;
 *                                         }
 *                                     }
 *                                     case label-case {
 *                                         container label {
 *                                             leaf uni-directional {
 *                                                 type boolean;
 *                                             }
 *                                             choice label-type {
 *                                                 case generalized-label-case {
 *                                                     container generalized-label {
 *                                                         leaf generalized-label {
 *                                                             type binary;
 *                                                         }
 *                                                         uses generalized-label;
 *                                                     }
 *                                                 }
 *                                                 case type1-label-case {
 *                                                     container type1-label {
 *                                                         leaf type1-label {
 *                                                             type uint32;
 *                                                         }
 *                                                         uses type1-label;
 *                                                     }
 *                                                 }
 *                                                 case waveband-switching-label-case {
 *                                                     container waveband-switching-label {
 *                                                         leaf end-label {
 *                                                             type uint32;
 *                                                         }
 *                                                         leaf start-label {
 *                                                             type uint32;
 *                                                         }
 *                                                         leaf waveband-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         uses waveband-switching-label;
 *                                                     }
 *                                                 }
 *                                             }
 *                                             uses label-subobject;
 *                                         }
 *                                     }
 *                                     case srlg-case {
 *                                         container srlg {
 *                                             leaf srlg-id {
 *                                                 type srlg-id;
 *                                             }
 *                                             uses srlg-subobject;
 *                                         }
 *                                     }
 *                                     case unnumbered-case {
 *                                         container unnumbered {
 *                                             leaf router-id {
 *                                                 type uint32;
 *                                             }
 *                                             leaf interface-id {
 *                                                 type uint32;
 *                                             }
 *                                             uses unnumbered-subobject;
 *                                         }
 *                                     }
 *                                 }
 *                                 uses exclude-route-subobjects;
 *                             }
 *                         }
 *                     }
 *                     case ip-prefix-case {
 *                         container ip-prefix {
 *                             leaf ip-prefix {
 *                                 type ip-prefix;
 *                             }
 *                             uses ip-prefix-subobject;
 *                         }
 *                     }
 *                     case label-case {
 *                         container label {
 *                             leaf uni-directional {
 *                                 type boolean;
 *                             }
 *                             choice label-type {
 *                                 case generalized-label-case {
 *                                     container generalized-label {
 *                                         leaf generalized-label {
 *                                             type binary;
 *                                         }
 *                                         uses generalized-label;
 *                                     }
 *                                 }
 *                                 case type1-label-case {
 *                                     container type1-label {
 *                                         leaf type1-label {
 *                                             type uint32;
 *                                         }
 *                                         uses type1-label;
 *                                     }
 *                                 }
 *                                 case waveband-switching-label-case {
 *                                     container waveband-switching-label {
 *                                         leaf end-label {
 *                                             type uint32;
 *                                         }
 *                                         leaf start-label {
 *                                             type uint32;
 *                                         }
 *                                         leaf waveband-id {
 *                                             type uint32;
 *                                         }
 *                                         uses waveband-switching-label;
 *                                     }
 *                                 }
 *                             }
 *                             uses label-subobject;
 *                         }
 *                     }
 *                     case path-key-case {
 *                         container path-key {
 *                             leaf pce-id {
 *                                 type pce-id;
 *                             }
 *                             leaf path-key {
 *                                 type path-key;
 *                             }
 *                             uses path-key-subobject;
 *                         }
 *                     }
 *                     case srlg-case {
 *                         container srlg {
 *                             leaf srlg-id {
 *                                 type srlg-id;
 *                             }
 *                             uses srlg-subobject;
 *                         }
 *                     }
 *                     case unnumbered-case {
 *                         container unnumbered {
 *                             leaf router-id {
 *                                 type uint32;
 *                             }
 *                             leaf interface-id {
 *                                 type uint32;
 *                             }
 *                             uses unnumbered-subobject;
 *                         }
 *                     }
 *                 }
 *                 uses explicit-route-subobjects;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         uses lsp-metadata;
 *         uses endpoints-object;
 *         uses path-definition;
 *     }
 *     leaf node {
 *         type node-ref;
 *     }
 *     leaf name {
 *         type string;
 *     }
 *     uses network-topology-reference;
 *     uses add-lsp-args;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>network-topology-pcep/add-lsp/input</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.AddLspInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.AddLspInputBuilder
 *
 */
public interface AddLspInput
    extends
    NetworkTopologyReference,
    AddLspArgs,
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.AddLspInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:pcep",
        "2013-10-24", "input").intern();


}

