package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.ensure.lsp.operational.args.Arguments;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>network-topology-pcep</b>
 * <pre>
 * grouping ensure-lsp-operational-args {
 *     leaf node {
 *         type node-ref;
 *     }
 *     leaf name {
 *         type string;
 *     }
 *     container arguments {
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>network-topology-pcep/ensure-lsp-operational-args</i>
 *
 */
public interface EnsureLspOperationalArgs
    extends
    DataObject,
    LspId
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:pcep",
        "2013-10-24", "ensure-lsp-operational-args").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.ensure.lsp.operational.args.Arguments</code> <code>arguments</code>, or <code>null</code> if not present
     */
    Arguments getArguments();

}

