package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.lsp.metadata.Metadata;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>network-topology-pcep</b>
 * <pre>
 * grouping lsp-metadata {
 *     container metadata {
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>network-topology-pcep/lsp-metadata</i>
 *
 */
public interface LspMetadata
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:pcep",
        "2013-10-24", "lsp-metadata").intern();

    /**
     * Container for external metadata attached to the LSP. Contents of this container 
     * are not propagated onto the router itself, so it is persisted only while the LSP
     * is present.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.lsp.metadata.Metadata</code> <code>metadata</code>, or <code>null</code> if not present
     */
    Metadata getMetadata();

}

