package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.lsp.metadata;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.LspMetadata;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * Container for external metadata attached to the LSP. Contents of this container 
 * are not propagated onto the router itself, so it is persisted only while the 
 * is present.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>network-topology-pcep</b>
 * <pre>
 * container metadata {
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>network-topology-pcep/lsp-metadata/metadata</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.lsp.metadata.MetadataBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.lsp.metadata.MetadataBuilder
 *
 */
public interface Metadata
    extends
    ChildOf<LspMetadata>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.lsp.metadata.Metadata>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:pcep",
        "2013-10-24", "metadata").intern();


}

