package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.operation.result;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PcepErrorObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.OperationResult;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>network-topology-pcep</b>
 * <pre>
 * list error {
 *     key     container error-object {
 *         container tlvs {
 *             container req-missing {
 *                 leaf request-id {
 *                     type request-id;
 *                 }
 *                 uses tlv;
 *             }
 *             list vendor-information-tlv {
 *                 key     leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses vendor-information;
 *                 uses tlv;
 *             }
 *             uses vendor-information-tlvs;
 *             uses req-missing-tlv;
 *         }
 *         leaf type {
 *             type uint8;
 *         }
 *         leaf value {
 *             type uint8;
 *         }
 *         leaf processing-rule {
 *             type processing-rule;
 *         }
 *         leaf ignore {
 *             type ignore;
 *         }
 *         uses object;
 *     }
 *     uses pcep-error-object;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>network-topology-pcep/operation-result/error</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.operation.result.ErrorBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.operation.result.ErrorBuilder
 *
 *
 */
public interface Error
    extends
    ChildOf<OperationResult>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.operation.result.Error>,
    PcepErrorObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:pcep",
        "2013-10-24", "error").intern();


}

