package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.config.rev171025;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev171025.pcep.node.config.SessionConfig;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.config.rev171025.PcepNodeConfig} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.config.rev171025.PcepNodeConfig
 *
 */
public class PcepNodeConfigBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.config.rev171025.PcepNodeConfig> {

    private SessionConfig _sessionConfig;


    public PcepNodeConfigBuilder() {
    }
    public PcepNodeConfigBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev171025.PcepNodeConfig arg) {
        this._sessionConfig = arg.getSessionConfig();
    }

    public PcepNodeConfigBuilder(PcepNodeConfig base) {
        this._sessionConfig = base.getSessionConfig();
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev171025.PcepNodeConfig</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev171025.PcepNodeConfig) {
            this._sessionConfig = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev171025.PcepNodeConfig)arg).getSessionConfig();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev171025.PcepNodeConfig] \n" +
              "but was: " + arg
            );
        }
    }

    public SessionConfig getSessionConfig() {
        return _sessionConfig;
    }

     
    public PcepNodeConfigBuilder setSessionConfig(final SessionConfig value) {
        this._sessionConfig = value;
        return this;
    }

    @Override
    public PcepNodeConfig build() {
        return new PcepNodeConfigImpl(this);
    }

    private static final class PcepNodeConfigImpl implements PcepNodeConfig {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.config.rev171025.PcepNodeConfig> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.config.rev171025.PcepNodeConfig.class;
        }

        private final SessionConfig _sessionConfig;


        private PcepNodeConfigImpl(PcepNodeConfigBuilder base) {
            this._sessionConfig = base.getSessionConfig();
        }

        @Override
        public SessionConfig getSessionConfig() {
            return _sessionConfig;
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_sessionConfig);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.config.rev171025.PcepNodeConfig.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.config.rev171025.PcepNodeConfig other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.config.rev171025.PcepNodeConfig)obj;
            if (!Objects.equals(_sessionConfig, other.getSessionConfig())) {
                return false;
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "PcepNodeConfig [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_sessionConfig != null) {
                builder.append("_sessionConfig=");
                builder.append(_sessionConfig);
            }
            return builder.append(']').toString();
        }
    }

}
