package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.programming.rev171025;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.programming.rev131102.TopologyInstructionInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.RemoveLspArgs;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-pcep-programming</b>
 * <pre>
 * container input {
 *     leaf id {
 *         type instruction-id;
 *     }
 *     leaf deadline {
 *         type nanotime;
 *     }
 *     leaf-list preconditions {
 *         type instruction-id;
 *     }
 *     leaf network-topology-ref {
 *         type network-topology-ref;
 *     }
 *     leaf name {
 *         type string;
 *     }
 *     leaf node {
 *         type node-ref;
 *     }
 *     uses remove-lsp-args;
 *     uses topology-instruction-input;
 * }
 * </pre>The schema path to identify an instance is
 * <i>network-topology-pcep-programming/submit-remove-lsp/input</i>
 *
 * <p>To create instances of this class use {@link SubmitRemoveLspInputBuilder}.
 * @see SubmitRemoveLspInputBuilder
 *
 */
public interface SubmitRemoveLspInput
    extends
    RemoveLspArgs,
    TopologyInstructionInput,
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.programming.rev171025.SubmitRemoveLspInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:pcep:programming",
        "2017-10-25", "input").intern();


}

