package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.programming.rev171025;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.programming.rev131102.TopologyInstructionInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.TriggerSyncArgs;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-pcep-programming</b>
 * <pre>
 * container input {
 *     leaf id {
 *         type instruction-id;
 *     }
 *     leaf deadline {
 *         type nanotime;
 *     }
 *     leaf-list preconditions {
 *         type instruction-id;
 *     }
 *     leaf network-topology-ref {
 *         type network-topology-ref;
 *     }
 *     leaf name {
 *         type string;
 *     }
 *     leaf node {
 *         type node-ref;
 *     }
 *     uses topology-instruction-input;
 *     uses trigger-sync-args;
 * }
 * </pre>The schema path to identify an instance is
 * <i>network-topology-pcep-programming/submit-trigger-sync/input</i>
 *
 * <p>To create instances of this class use {@link SubmitTriggerSyncInputBuilder}.
 * @see SubmitTriggerSyncInputBuilder
 *
 */
public interface SubmitTriggerSyncInput
    extends
    TopologyInstructionInput,
    TriggerSyncArgs,
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.programming.rev171025.SubmitTriggerSyncInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:pcep:programming",
        "2017-10-25", "input").intern();


}

