package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025;

public enum FailureType {
    /**
     * The request failed before it was sent to the PCC.PCC's state is guaranteed not 
     * to reflect statetransition implied by the request. This typicallyhappens if the 
     * request is syntactically invalid,the target PCC is not connected or 
     * disconnectswhile the request is enqueued.
     *
     */
    Unsent(0, "unsent"),
    
    /**
     * The request has been sent to the PCC, but either thesession went down before we 
     * have received confirmationof the request being received by the PCC, or the 
     * requesttimed-out waiting for response from PCC. PCC's state isunknown -- the 
     * request may or may not be reflectedin its internal state. The caller should not 
     * makeany hard assumptions about PCC state until it reconnectsand state 
     * synchronization completes.
     *
     */
    NoAck(1, "no-ack"),
    
    /**
     * The request has been seen by the PCC, where it failedfor some external reason. 
     * The caller can assume thestate transition has not taken place, but is advisedto 
     * examine the attached error list to gain a deeperunderstanding of the failure 
     * cause.
     *
     */
    Failed(2, "failed")
    ;

    private static final java.util.Map<java.lang.Integer, FailureType> VALUE_MAP;

    static {
        final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, FailureType> b = com.google.common.collect.ImmutableMap.builder();
        for (FailureType enumItem : FailureType.values()) {
            b.put(enumItem.value, enumItem);
        }

        VALUE_MAP = b.build();
    }

    private final java.lang.String name;
    private final int value;

    private FailureType(int value, java.lang.String name) {
        this.value = value;
        this.name = name;
    }

    /**
     * Returns the name of the enumeration item as it is specified in the input yang.
     *
     * @return the name of the enumeration item as it is specified in the input yang
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * @return integer value
     */
    public int getIntValue() {
        return value;
    }

    /**
     * @param valueArg integer value
     * @return corresponding FailureType item
     */
    public static FailureType forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }
}
