package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.lsp.metadata.Metadata;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-pcep</b>
 * <pre>
 * grouping lsp-metadata {
 *     container metadata {
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>network-topology-pcep/lsp-metadata</i>
 *
 */
public interface LspMetadata
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:pcep",
        "2017-10-25", "lsp-metadata").intern();

    /**
     * Container for external metadata attached to the LSP. Contents of this 
     * containerare not propagated onto the router itself, so it is persisted only 
     * while the LSPis present.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.lsp.metadata.Metadata</code> <code>metadata</code>, or <code>null</code> if not present
     */
    Metadata getMetadata();

}

