package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.operation.result.Error;
import java.util.List;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-pcep</b>
 * <pre>
 * grouping operation-result {
 *     leaf failure {
 *         type failure-type;
 *     }
 *     list error {
 *         container error-object {
 *             container tlvs {
 *                 container req-missing {
 *                     leaf request-id {
 *                         type request-id;
 *                     }
 *                     uses tlv;
 *                 }
 *                 list vendor-information-tlv {
 *                     leaf enterprise-number {
 *                         type enterprise-number;
 *                     }
 *                     choice enterprise-specific-information {
 *                     }
 *                     uses tlv;
 *                     uses vendor-information;
 *                 }
 *                 uses vendor-information-tlvs;
 *                 uses req-missing-tlv;
 *             }
 *             leaf type {
 *                 type uint8;
 *             }
 *             leaf value {
 *                 type uint8;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         uses pcep-error-object;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>network-topology-pcep/operation-result</i>
 *
 */
public interface OperationResult
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:pcep",
        "2017-10-25", "operation-result").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.FailureType</code> <code>failure</code>, or <code>null</code> if not present
     */
    FailureType getFailure();
    
    /**
     * @return <code>java.util.List</code> <code>error</code>, or <code>null</code> if not present
     */
    List<Error> getError();

}

