package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025;

public enum PccSyncState {
    /**
     * Initial state resynchronization is being performed.
     *
     */
    InitialResync(0, "initial-resync"),
    
    /**
     * Incremental state resynchronization is being performed.
     *
     */
    IncrementalSync(1, "incremental-sync"),
    
    /**
     * Triggered initial state resynchronization is being performed.
     *
     */
    TriggeredInitialSync(2, "triggered-initial-sync"),
    
    /**
     * Pcep triggered state resynchronization is being performed.
     *
     */
    PcepTriggeredResync(3, "pcep-triggered-resync"),
    
    /**
     * State synchronization has been achieved.
     *
     */
    Synchronized(4, "synchronized")
    ;

    private static final java.util.Map<java.lang.Integer, PccSyncState> VALUE_MAP;

    static {
        final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, PccSyncState> b = com.google.common.collect.ImmutableMap.builder();
        for (PccSyncState enumItem : PccSyncState.values()) {
            b.put(enumItem.value, enumItem);
        }

        VALUE_MAP = b.build();
    }

    private final java.lang.String name;
    private final int value;

    private PccSyncState(int value, java.lang.String name) {
        this.value = value;
        this.name = name;
    }

    /**
     * Returns the name of the enumeration item as it is specified in the input yang.
     *
     * @return the name of the enumeration item as it is specified in the input yang
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * @return integer value
     */
    public int getIntValue() {
        return value;
    }

    /**
     * @param valueArg integer value
     * @return corresponding PccSyncState item
     */
    public static PccSyncState forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }
}
