package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.pcep.client.attributes.PathComputationClient;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Data present in a node which is a PCEP client (PCC).
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-pcep</b>
 * <pre>
 * grouping pcep-client-attributes {
 *     container path-computation-client {
 *         leaf ip-address {
 *             type ip-address;
 *         }
 *         container stateful-tlv {
 *         }
 *         leaf state-sync {
 *             type pcc-sync-state;
 *         }
 *         list reported-lsp {
 *             key "name";
 *             leaf name {
 *                 type string;
 *             }
 *             list path {
 *                 key "lsp-id";
 *                 leaf lsp-id {
 *                     type lsp-id;
 *                 }
 *                 container ero {
 *                     list subobject {
 *                         leaf loose {
 *                             type boolean;
 *                         }
 *                         choice subobject-type {
 *                             case as-number-case {
 *                                 container as-number {
 *                                     leaf as-number {
 *                                         type as-number;
 *                                     }
 *                                     uses as-number-subobject;
 *                                 }
 *                             }
 *                             case exrs-case {
 *                                 container exrs {
 *                                     list exrs {
 *                                         leaf mandatory {
 *                                             type mandatory;
 *                                         }
 *                                         leaf attribute {
 *                                             type enumeration;
 *                                         }
 *                                         choice subobject-type {
 *                                             case as-number-case {
 *                                                 container as-number {
 *                                                     leaf as-number {
 *                                                         type as-number;
 *                                                     }
 *                                                     uses as-number-subobject;
 *                                                 }
 *                                             }
 *                                             case ip-prefix-case {
 *                                                 container ip-prefix {
 *                                                     leaf ip-prefix {
 *                                                         type ip-prefix;
 *                                                     }
 *                                                     uses ip-prefix-subobject;
 *                                                 }
 *                                             }
 *                                             case label-case {
 *                                                 container label {
 *                                                     leaf uni-directional {
 *                                                         type boolean;
 *                                                     }
 *                                                     choice label-type {
 *                                                         case generalized-label-case {
 *                                                             container generalized-label {
 *                                                                 leaf generalized-label {
 *                                                                     type binary;
 *                                                                 }
 *                                                                 uses generalized-label;
 *                                                             }
 *                                                         }
 *                                                         case type1-label-case {
 *                                                             container type1-label {
 *                                                                 leaf type1-label {
 *                                                                     type uint32;
 *                                                                 }
 *                                                                 uses type1-label;
 *                                                             }
 *                                                         }
 *                                                         case waveband-switching-label-case {
 *                                                             container waveband-switching-label {
 *                                                                 leaf end-label {
 *                                                                     type uint32;
 *                                                                 }
 *                                                                 leaf start-label {
 *                                                                     type uint32;
 *                                                                 }
 *                                                                 leaf waveband-id {
 *                                                                     type uint32;
 *                                                                 }
 *                                                                 uses waveband-switching-label;
 *                                                             }
 *                                                         }
 *                                                     }
 *                                                     uses label-subobject;
 *                                                 }
 *                                             }
 *                                             case srlg-case {
 *                                                 container srlg {
 *                                                     leaf srlg-id {
 *                                                         type srlg-id;
 *                                                     }
 *                                                     uses srlg-subobject;
 *                                                 }
 *                                             }
 *                                             case unnumbered-case {
 *                                                 container unnumbered {
 *                                                     leaf router-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf interface-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses unnumbered-subobject;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses exclude-route-subobjects;
 *                                     }
 *                                 }
 *                             }
 *                             case ip-prefix-case {
 *                                 container ip-prefix {
 *                                     leaf ip-prefix {
 *                                         type ip-prefix;
 *                                     }
 *                                     uses ip-prefix-subobject;
 *                                 }
 *                             }
 *                             case label-case {
 *                                 container label {
 *                                     leaf uni-directional {
 *                                         type boolean;
 *                                     }
 *                                     choice label-type {
 *                                         case generalized-label-case {
 *                                             container generalized-label {
 *                                                 leaf generalized-label {
 *                                                     type binary;
 *                                                 }
 *                                                 uses generalized-label;
 *                                             }
 *                                         }
 *                                         case type1-label-case {
 *                                             container type1-label {
 *                                                 leaf type1-label {
 *                                                     type uint32;
 *                                                 }
 *                                                 uses type1-label;
 *                                             }
 *                                         }
 *                                         case waveband-switching-label-case {
 *                                             container waveband-switching-label {
 *                                                 leaf end-label {
 *                                                     type uint32;
 *                                                 }
 *                                                 leaf start-label {
 *                                                     type uint32;
 *                                                 }
 *                                                 leaf waveband-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 uses waveband-switching-label;
 *                                             }
 *                                         }
 *                                     }
 *                                     uses label-subobject;
 *                                 }
 *                             }
 *                             case path-key-case {
 *                                 container path-key {
 *                                     leaf pce-id {
 *                                         type pce-id;
 *                                     }
 *                                     leaf path-key {
 *                                         type path-key;
 *                                     }
 *                                     uses path-key-subobject;
 *                                 }
 *                             }
 *                             case srlg-case {
 *                                 container srlg {
 *                                     leaf srlg-id {
 *                                         type srlg-id;
 *                                     }
 *                                     uses srlg-subobject;
 *                                 }
 *                             }
 *                             case unnumbered-case {
 *                                 container unnumbered {
 *                                     leaf router-id {
 *                                         type uint32;
 *                                     }
 *                                     leaf interface-id {
 *                                         type uint32;
 *                                     }
 *                                     uses unnumbered-subobject;
 *                                 }
 *                             }
 *                         }
 *                         uses explicit-route-subobjects;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 list metrics {
 *                     container metric {
 *                         leaf metric-type {
 *                             type uint8;
 *                         }
 *                         leaf bound {
 *                             type bound;
 *                         }
 *                         leaf computed {
 *                             type computed;
 *                         }
 *                         leaf value {
 *                             type float32;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     uses metric-object;
 *                 }
 *                 container bandwidth {
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     leaf bandwidth {
 *                         type bandwidth;
 *                     }
 *                     uses bandwidth;
 *                     uses object;
 *                 }
 *                 container class-type {
 *                     leaf class-type {
 *                         type class-type;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 container reoptimization-bandwidth {
 *                     leaf bandwidth {
 *                         type bandwidth;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses bandwidth;
 *                     uses object;
 *                 }
 *                 container lspa {
 *                     container tlvs {
 *                         list vendor-information-tlv {
 *                             leaf enterprise-number {
 *                                 type enterprise-number;
 *                             }
 *                             choice enterprise-specific-information {
 *                             }
 *                             uses tlv;
 *                             uses vendor-information;
 *                         }
 *                         uses vendor-information-tlvs;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     leaf local-protection-desired {
 *                         type local-protection-desired;
 *                     }
 *                     leaf label-recording-desired {
 *                         type label-recording-desired;
 *                     }
 *                     leaf se-style-desired {
 *                         type se-style-desired;
 *                     }
 *                     leaf session-name {
 *                         type string;
 *                     }
 *                     leaf hold-priority {
 *                         type hold-priority;
 *                     }
 *                     leaf setup-priority {
 *                         type setup-priority;
 *                     }
 *                     leaf include-any {
 *                         type attribute-filter;
 *                     }
 *                     leaf exclude-any {
 *                         type attribute-filter;
 *                     }
 *                     leaf include-all {
 *                         type attribute-filter;
 *                     }
 *                     uses tunnel-attributes;
 *                     uses object;
 *                 }
 *                 container of {
 *                     leaf code {
 *                         type of-id;
 *                     }
 *                     container tlvs {
 *                         list vendor-information-tlv {
 *                             leaf enterprise-number {
 *                                 type enterprise-number;
 *                             }
 *                             choice enterprise-specific-information {
 *                             }
 *                             uses tlv;
 *                             uses vendor-information;
 *                         }
 *                         uses vendor-information-tlvs;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 container rro {
 *                     list subobject {
 *                         leaf protection-available {
 *                             type protection-available;
 *                         }
 *                         leaf protection-in-use {
 *                             type protection-in-use;
 *                         }
 *                         choice subobject-type {
 *                             case ip-prefix-case {
 *                                 container ip-prefix {
 *                                     leaf ip-prefix {
 *                                         type ip-prefix;
 *                                     }
 *                                     uses ip-prefix-subobject;
 *                                 }
 *                             }
 *                             case label-case {
 *                                 container label {
 *                                     leaf global {
 *                                         type global;
 *                                     }
 *                                     leaf uni-directional {
 *                                         type boolean;
 *                                     }
 *                                     choice label-type {
 *                                         case generalized-label-case {
 *                                             container generalized-label {
 *                                                 leaf generalized-label {
 *                                                     type binary;
 *                                                 }
 *                                                 uses generalized-label;
 *                                             }
 *                                         }
 *                                         case type1-label-case {
 *                                             container type1-label {
 *                                                 leaf type1-label {
 *                                                     type uint32;
 *                                                 }
 *                                                 uses type1-label;
 *                                             }
 *                                         }
 *                                         case waveband-switching-label-case {
 *                                             container waveband-switching-label {
 *                                                 leaf end-label {
 *                                                     type uint32;
 *                                                 }
 *                                                 leaf start-label {
 *                                                     type uint32;
 *                                                 }
 *                                                 leaf waveband-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 uses waveband-switching-label;
 *                                             }
 *                                         }
 *                                     }
 *                                     uses label-subobject;
 *                                 }
 *                             }
 *                             case path-key-case {
 *                                 container path-key {
 *                                     leaf pce-id {
 *                                         type pce-id;
 *                                     }
 *                                     leaf path-key {
 *                                         type path-key;
 *                                     }
 *                                     uses path-key-subobject;
 *                                 }
 *                             }
 *                             case unnumbered-case {
 *                                 container unnumbered {
 *                                     leaf router-id {
 *                                         type uint32;
 *                                     }
 *                                     leaf interface-id {
 *                                         type uint32;
 *                                     }
 *                                     uses unnumbered-subobject;
 *                                 }
 *                             }
 *                         }
 *                         uses record-route-subobjects;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 container xro {
 *                     leaf flags {
 *                         type bits;
 *                     }
 *                     list subobject {
 *                         leaf mandatory {
 *                             type mandatory;
 *                         }
 *                         leaf attribute {
 *                             type enumeration;
 *                         }
 *                         choice subobject-type {
 *                             case as-number-case {
 *                                 container as-number {
 *                                     leaf as-number {
 *                                         type as-number;
 *                                     }
 *                                     uses as-number-subobject;
 *                                 }
 *                             }
 *                             case ip-prefix-case {
 *                                 container ip-prefix {
 *                                     leaf ip-prefix {
 *                                         type ip-prefix;
 *                                     }
 *                                     uses ip-prefix-subobject;
 *                                 }
 *                             }
 *                             case label-case {
 *                                 container label {
 *                                     leaf uni-directional {
 *                                         type boolean;
 *                                     }
 *                                     choice label-type {
 *                                         case generalized-label-case {
 *                                             container generalized-label {
 *                                                 leaf generalized-label {
 *                                                     type binary;
 *                                                 }
 *                                                 uses generalized-label;
 *                                             }
 *                                         }
 *                                         case type1-label-case {
 *                                             container type1-label {
 *                                                 leaf type1-label {
 *                                                     type uint32;
 *                                                 }
 *                                                 uses type1-label;
 *                                             }
 *                                         }
 *                                         case waveband-switching-label-case {
 *                                             container waveband-switching-label {
 *                                                 leaf end-label {
 *                                                     type uint32;
 *                                                 }
 *                                                 leaf start-label {
 *                                                     type uint32;
 *                                                 }
 *                                                 leaf waveband-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 uses waveband-switching-label;
 *                                             }
 *                                         }
 *                                     }
 *                                     uses label-subobject;
 *                                 }
 *                             }
 *                             case srlg-case {
 *                                 container srlg {
 *                                     leaf srlg-id {
 *                                         type srlg-id;
 *                                     }
 *                                     uses srlg-subobject;
 *                                 }
 *                             }
 *                             case unnumbered-case {
 *                                 container unnumbered {
 *                                     leaf router-id {
 *                                         type uint32;
 *                                     }
 *                                     leaf interface-id {
 *                                         type uint32;
 *                                     }
 *                                     uses unnumbered-subobject;
 *                                 }
 *                             }
 *                         }
 *                         uses exclude-route-subobjects;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 container iro {
 *                     list subobject {
 *                         leaf loose {
 *                             type boolean;
 *                         }
 *                         choice subobject-type {
 *                             case as-number-case {
 *                                 container as-number {
 *                                     leaf as-number {
 *                                         type as-number;
 *                                     }
 *                                     uses as-number-subobject;
 *                                 }
 *                             }
 *                             case exrs-case {
 *                                 container exrs {
 *                                     list exrs {
 *                                         leaf mandatory {
 *                                             type mandatory;
 *                                         }
 *                                         leaf attribute {
 *                                             type enumeration;
 *                                         }
 *                                         choice subobject-type {
 *                                             case as-number-case {
 *                                                 container as-number {
 *                                                     leaf as-number {
 *                                                         type as-number;
 *                                                     }
 *                                                     uses as-number-subobject;
 *                                                 }
 *                                             }
 *                                             case ip-prefix-case {
 *                                                 container ip-prefix {
 *                                                     leaf ip-prefix {
 *                                                         type ip-prefix;
 *                                                     }
 *                                                     uses ip-prefix-subobject;
 *                                                 }
 *                                             }
 *                                             case label-case {
 *                                                 container label {
 *                                                     leaf uni-directional {
 *                                                         type boolean;
 *                                                     }
 *                                                     choice label-type {
 *                                                         case generalized-label-case {
 *                                                             container generalized-label {
 *                                                                 leaf generalized-label {
 *                                                                     type binary;
 *                                                                 }
 *                                                                 uses generalized-label;
 *                                                             }
 *                                                         }
 *                                                         case type1-label-case {
 *                                                             container type1-label {
 *                                                                 leaf type1-label {
 *                                                                     type uint32;
 *                                                                 }
 *                                                                 uses type1-label;
 *                                                             }
 *                                                         }
 *                                                         case waveband-switching-label-case {
 *                                                             container waveband-switching-label {
 *                                                                 leaf end-label {
 *                                                                     type uint32;
 *                                                                 }
 *                                                                 leaf start-label {
 *                                                                     type uint32;
 *                                                                 }
 *                                                                 leaf waveband-id {
 *                                                                     type uint32;
 *                                                                 }
 *                                                                 uses waveband-switching-label;
 *                                                             }
 *                                                         }
 *                                                     }
 *                                                     uses label-subobject;
 *                                                 }
 *                                             }
 *                                             case srlg-case {
 *                                                 container srlg {
 *                                                     leaf srlg-id {
 *                                                         type srlg-id;
 *                                                     }
 *                                                     uses srlg-subobject;
 *                                                 }
 *                                             }
 *                                             case unnumbered-case {
 *                                                 container unnumbered {
 *                                                     leaf router-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf interface-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses unnumbered-subobject;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses exclude-route-subobjects;
 *                                     }
 *                                 }
 *                             }
 *                             case ip-prefix-case {
 *                                 container ip-prefix {
 *                                     leaf ip-prefix {
 *                                         type ip-prefix;
 *                                     }
 *                                     uses ip-prefix-subobject;
 *                                 }
 *                             }
 *                             case label-case {
 *                                 container label {
 *                                     leaf uni-directional {
 *                                         type boolean;
 *                                     }
 *                                     choice label-type {
 *                                         case generalized-label-case {
 *                                             container generalized-label {
 *                                                 leaf generalized-label {
 *                                                     type binary;
 *                                                 }
 *                                                 uses generalized-label;
 *                                             }
 *                                         }
 *                                         case type1-label-case {
 *                                             container type1-label {
 *                                                 leaf type1-label {
 *                                                     type uint32;
 *                                                 }
 *                                                 uses type1-label;
 *                                             }
 *                                         }
 *                                         case waveband-switching-label-case {
 *                                             container waveband-switching-label {
 *                                                 leaf end-label {
 *                                                     type uint32;
 *                                                 }
 *                                                 leaf start-label {
 *                                                     type uint32;
 *                                                 }
 *                                                 leaf waveband-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 uses waveband-switching-label;
 *                                             }
 *                                         }
 *                                     }
 *                                     uses label-subobject;
 *                                 }
 *                             }
 *                             case path-key-case {
 *                                 container path-key {
 *                                     leaf pce-id {
 *                                         type pce-id;
 *                                     }
 *                                     leaf path-key {
 *                                         type path-key;
 *                                     }
 *                                     uses path-key-subobject;
 *                                 }
 *                             }
 *                             case srlg-case {
 *                                 container srlg {
 *                                     leaf srlg-id {
 *                                         type srlg-id;
 *                                     }
 *                                     uses srlg-subobject;
 *                                 }
 *                             }
 *                             case unnumbered-case {
 *                                 container unnumbered {
 *                                     leaf router-id {
 *                                         type uint32;
 *                                     }
 *                                     leaf interface-id {
 *                                         type uint32;
 *                                     }
 *                                     uses unnumbered-subobject;
 *                                 }
 *                             }
 *                         }
 *                         uses explicit-route-subobjects;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 uses path-definition;
 *             }
 *             container metadata {
 *             }
 *             uses lsp-metadata;
 *         }
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>network-topology-pcep/pcep-client-attributes</i>
 *
 */
public interface PcepClientAttributes
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:pcep",
        "2017-10-25", "pcep-client-attributes").intern();

    /**
     * PCC-related run-time information. This container is onlypresent when the node is
     * connected through PCEP in a PCCrole.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.pcep.client.attributes.PathComputationClient</code> <code>pathComputationClient</code>, or <code>null</code> if not present
     */
    PathComputationClient getPathComputationClient();

}

