package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-pcep</b>
 * <pre>
 * container input {
 *     leaf network-topology-ref {
 *         type network-topology-ref;
 *     }
 *     leaf name {
 *         type string;
 *     }
 *     leaf node {
 *         type node-ref;
 *     }
 *     uses network-topology-reference;
 *     uses trigger-sync-args;
 * }
 * </pre>The schema path to identify an instance is
 * <i>network-topology-pcep/trigger-sync/input</i>
 *
 * <p>To create instances of this class use {@link TriggerSyncInputBuilder}.
 * @see TriggerSyncInputBuilder
 *
 */
public interface TriggerSyncInput
    extends
    NetworkTopologyReference,
    TriggerSyncArgs,
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.TriggerSyncInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:pcep",
        "2017-10-25", "input").intern();


}

