package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.lsp.metadata;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.LspMetadata;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * Container for external metadata attached to the LSP. Contents of this 
 * containerare not propagated onto the router itself, so it is persisted only 
 * while the LSPis present.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-pcep</b>
 * <pre>
 * container metadata {
 * }
 * </pre>The schema path to identify an instance is
 * <i>network-topology-pcep/lsp-metadata/metadata</i>
 *
 * <p>To create instances of this class use {@link MetadataBuilder}.
 * @see MetadataBuilder
 *
 */
public interface Metadata
    extends
    ChildOf<LspMetadata>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.lsp.metadata.Metadata>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:pcep",
        "2017-10-25", "metadata").intern();


}

