package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.pcep.client.attributes.path.computation.client.reported.lsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LspId;
import org.opendaylight.yangtools.yang.binding.Identifier;
import java.util.Objects;

public class PathKey
 implements Identifier<Path> {
    private static final long serialVersionUID = 1859403506475555741L;
    private final LspId _lspId;


    public PathKey(LspId _lspId) {
    
    
        this._lspId = _lspId;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public PathKey(PathKey source) {
        this._lspId = source._lspId;
    }


    public LspId getLspId() {
        return _lspId;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_lspId);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        PathKey other = (PathKey) obj;
        if (!Objects.equals(_lspId, other._lspId)) {
            return false;
        }
        return true;
    }

    @Override
    public java.lang.String toString() {
        java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.pcep.client.attributes.path.computation.client.reported.lsp.PathKey.class.getSimpleName()).append(" [");
        boolean first = true;
    
        if (_lspId != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_lspId=");
            builder.append(_lspId);
        }
        return builder.append(']').toString();
    }
}

