package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.stats.rev171113;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.grouping.PcepSessionState;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.stats.rev171113.PcepTopologyNodeStatsAug} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.stats.rev171113.PcepTopologyNodeStatsAug
 *
 */
public class PcepTopologyNodeStatsAugBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.stats.rev171113.PcepTopologyNodeStatsAug> {

    private PcepSessionState _pcepSessionState;


    public PcepTopologyNodeStatsAugBuilder() {
    }
    public PcepTopologyNodeStatsAugBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionStateGrouping arg) {
        this._pcepSessionState = arg.getPcepSessionState();
    }

    public PcepTopologyNodeStatsAugBuilder(PcepTopologyNodeStatsAug base) {
        this._pcepSessionState = base.getPcepSessionState();
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionStateGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionStateGrouping) {
            this._pcepSessionState = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionStateGrouping)arg).getPcepSessionState();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionStateGrouping] \n" +
              "but was: " + arg
            );
        }
    }

    public PcepSessionState getPcepSessionState() {
        return _pcepSessionState;
    }

     
    public PcepTopologyNodeStatsAugBuilder setPcepSessionState(final PcepSessionState value) {
        this._pcepSessionState = value;
        return this;
    }

    @Override
    public PcepTopologyNodeStatsAug build() {
        return new PcepTopologyNodeStatsAugImpl(this);
    }

    private static final class PcepTopologyNodeStatsAugImpl implements PcepTopologyNodeStatsAug {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.stats.rev171113.PcepTopologyNodeStatsAug> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.stats.rev171113.PcepTopologyNodeStatsAug.class;
        }

        private final PcepSessionState _pcepSessionState;


        private PcepTopologyNodeStatsAugImpl(PcepTopologyNodeStatsAugBuilder base) {
            this._pcepSessionState = base.getPcepSessionState();
        }

        @Override
        public PcepSessionState getPcepSessionState() {
            return _pcepSessionState;
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_pcepSessionState);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.stats.rev171113.PcepTopologyNodeStatsAug.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.stats.rev171113.PcepTopologyNodeStatsAug other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.stats.rev171113.PcepTopologyNodeStatsAug)obj;
            if (!Objects.equals(_pcepSessionState, other.getPcepSessionState())) {
                return false;
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "PcepTopologyNodeStatsAug [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_pcepSessionState != null) {
                builder.append("_pcepSessionState=");
                builder.append(_pcepSessionState);
            }
            return builder.append(']').toString();
        }
    }

}
