/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.pcep.topology.spi;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.bgpcep.programming.spi.Instruction;
import org.opendaylight.bgpcep.programming.spi.InstructionScheduler;
import org.opendaylight.bgpcep.programming.spi.SchedulerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.SubmitInstructionInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.submit.instruction.output.result.FailureCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.submit.instruction.output.result.FailureCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.FailureType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.OperationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInstructionExecutor
implements FutureCallback<Instruction> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractInstructionExecutor.class);
    private final SubmitInstructionInput input;

    protected AbstractInstructionExecutor(@NonNull SubmitInstructionInput input) {
        this.input = Objects.requireNonNull(input);
    }

    public static FailureCase schedule(InstructionScheduler scheduler, AbstractInstructionExecutor fwd) {
        ListenableFuture listenableFuture;
        SubmitInstructionInput input = fwd.getInput();
        try {
            listenableFuture = scheduler.scheduleInstruction(input);
        }
        catch (SchedulerException e) {
            LOG.info("Instuction {} failed to schedule", (Object)input, (Object)e);
            return new FailureCaseBuilder().setFailure(e.getFailure()).build();
        }
        Futures.addCallback((ListenableFuture)listenableFuture, (FutureCallback)fwd, (Executor)MoreExecutors.directExecutor());
        return null;
    }

    public final SubmitInstructionInput getInput() {
        return this.input;
    }

    protected abstract ListenableFuture<OperationResult> invokeOperation();

    public void onSuccess(Instruction insn) {
        if (insn != null && insn.checkedExecutionStart()) {
            ListenableFuture<OperationResult> listenableFuture = this.invokeOperation();
            Futures.addCallback(listenableFuture, (FutureCallback)new InstructionCallback(insn), (Executor)MoreExecutors.directExecutor());
        }
    }

    public void onFailure(Throwable throwable) {
        LOG.debug("Instruction {} cancelled", (Object)this.input, (Object)throwable);
    }

    private static final class InstructionCallback
    implements FutureCallback<OperationResult> {
        private final Instruction insn;

        InstructionCallback(@NonNull Instruction insn) {
            this.insn = Objects.requireNonNull(insn);
        }

        public void onSuccess(OperationResult result) {
            if (result != null) {
                FailureType failure = result.getFailure();
                if (failure != null) {
                    switch (failure) {
                        case Failed: 
                        case NoAck: {
                            this.insn.executionCompleted(InstructionStatus.Failed, null);
                            break;
                        }
                        case Unsent: {
                            this.insn.executionCompleted(InstructionStatus.Cancelled, null);
                            break;
                        }
                    }
                }
            } else {
                this.insn.executionCompleted(InstructionStatus.Successful, null);
            }
        }

        public void onFailure(Throwable throwable) {
            this.insn.executionCompleted(InstructionStatus.Failed, null);
        }
    }
}

