/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.pcep.topology.spi;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.opendaylight.bgpcep.programming.spi.Instruction;
import org.opendaylight.bgpcep.programming.spi.InstructionScheduler;
import org.opendaylight.bgpcep.programming.spi.SchedulerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev130930.InstructionStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev130930.SubmitInstructionInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev130930.submit.instruction.output.result.FailureCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev130930.submit.instruction.output.result.FailureCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev131024.OperationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInstructionExecutor
implements FutureCallback<Instruction> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractInstructionExecutor.class);
    private final SubmitInstructionInput input;

    protected AbstractInstructionExecutor(SubmitInstructionInput input) {
        this.input = (SubmitInstructionInput)Preconditions.checkNotNull((Object)input);
    }

    public final SubmitInstructionInput getInput() {
        return this.input;
    }

    public static FailureCase schedule(InstructionScheduler scheduler, AbstractInstructionExecutor fwd) {
        ListenableFuture s;
        try {
            s = scheduler.scheduleInstruction(fwd.getInput());
        }
        catch (SchedulerException e) {
            LOG.info("Instuction {} failed to schedule", (Object)e.getMessage(), (Object)e);
            return new FailureCaseBuilder().setFailure(e.getFailure()).build();
        }
        Futures.addCallback((ListenableFuture)s, (FutureCallback)fwd);
        return null;
    }

    protected abstract ListenableFuture<OperationResult> invokeOperation();

    public void onSuccess(Instruction insn) {
        if (insn.checkedExecutionStart()) {
            ListenableFuture<OperationResult> s = this.invokeOperation();
            Futures.addCallback(s, (FutureCallback)new InstructionCallback(insn));
        }
    }

    public void onFailure(Throwable t) {
        LOG.debug("Instruction {} cancelled", (Object)this.input, (Object)t);
    }

    private static final class InstructionCallback
    implements FutureCallback<OperationResult> {
        private final Instruction insn;

        public InstructionCallback(Instruction insn) {
            this.insn = insn;
        }

        public void onSuccess(OperationResult result) {
            if (result.getFailure() != null) {
                switch (result.getFailure()) {
                    case Failed: 
                    case NoAck: {
                        this.insn.executionCompleted(InstructionStatus.Failed, null);
                        break;
                    }
                    case Unsent: {
                        this.insn.executionCompleted(InstructionStatus.Cancelled, null);
                        break;
                    }
                }
            } else {
                this.insn.executionCompleted(InstructionStatus.Successful, null);
            }
        }

        public void onFailure(Throwable t) {
            this.insn.executionCompleted(InstructionStatus.Failed, null);
        }
    }
}

