package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev181109;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.SubmitInstructionOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.submit.instruction.output.Result;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.programming.rev131102.TopologyInstructionOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.BaseTunnelOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.CreateP2pTunnelOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.CreateTunnelOutput;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PcepCreateP2pTunnelOutputBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PcepCreateP2pTunnelOutputBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new PcepCreateP2pTunnelOutputBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PcepCreateP2pTunnelOutputBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PcepCreateP2pTunnelOutputBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class PcepCreateP2pTunnelOutputBuilder implements Builder<PcepCreateP2pTunnelOutput> {

    private LinkId _linkId;
    private Result _result;


    Map<Class<? extends Augmentation<PcepCreateP2pTunnelOutput>>, Augmentation<PcepCreateP2pTunnelOutput>> augmentation = Collections.emptyMap();

    public PcepCreateP2pTunnelOutputBuilder() {
    }
    
    
    
    public PcepCreateP2pTunnelOutputBuilder(CreateP2pTunnelOutput arg) {
        this._linkId = arg.getLinkId();
        this._result = arg.getResult();
    }
    public PcepCreateP2pTunnelOutputBuilder(CreateTunnelOutput arg) {
        this._linkId = arg.getLinkId();
        this._result = arg.getResult();
    }
    public PcepCreateP2pTunnelOutputBuilder(BaseTunnelOutput arg) {
        this._result = arg.getResult();
    }
    public PcepCreateP2pTunnelOutputBuilder(TopologyInstructionOutput arg) {
        this._result = arg.getResult();
    }
    public PcepCreateP2pTunnelOutputBuilder(SubmitInstructionOutput arg) {
        this._result = arg.getResult();
    }

    public PcepCreateP2pTunnelOutputBuilder(PcepCreateP2pTunnelOutput base) {
        Map<Class<? extends Augmentation<PcepCreateP2pTunnelOutput>>, Augmentation<PcepCreateP2pTunnelOutput>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._linkId = base.getLinkId();
        this._result = base.getResult();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>BaseTunnelOutput</li>
     * <li>TopologyInstructionOutput</li>
     * <li>SubmitInstructionOutput</li>
     * <li>CreateP2pTunnelOutput</li>
     * <li>CreateTunnelOutput</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BaseTunnelOutput) {
            isValidArg = true;
        }
        if (arg instanceof TopologyInstructionOutput) {
            isValidArg = true;
        }
        if (arg instanceof SubmitInstructionOutput) {
            this._result = ((SubmitInstructionOutput)arg).getResult();
            isValidArg = true;
        }
        if (arg instanceof CreateP2pTunnelOutput) {
            isValidArg = true;
        }
        if (arg instanceof CreateTunnelOutput) {
            this._linkId = ((CreateTunnelOutput)arg).getLinkId();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[BaseTunnelOutput, TopologyInstructionOutput, SubmitInstructionOutput, CreateP2pTunnelOutput, CreateTunnelOutput]");
    }

    public LinkId getLinkId() {
        return _linkId;
    }
    
    public Result getResult() {
        return _result;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<PcepCreateP2pTunnelOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public PcepCreateP2pTunnelOutputBuilder setLinkId(final LinkId value) {
        this._linkId = value;
        return this;
    }
    
    public PcepCreateP2pTunnelOutputBuilder setResult(final Result value) {
        this._result = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PcepCreateP2pTunnelOutputBuilder addAugmentation(Augmentation<PcepCreateP2pTunnelOutput> augmentation) {
        Class<? extends Augmentation<PcepCreateP2pTunnelOutput>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PcepCreateP2pTunnelOutputBuilder removeAugmentation(Class<? extends Augmentation<PcepCreateP2pTunnelOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PcepCreateP2pTunnelOutput build() {
        return new PcepCreateP2pTunnelOutputImpl(this);
    }

    private static final class PcepCreateP2pTunnelOutputImpl
        extends AbstractAugmentable<PcepCreateP2pTunnelOutput>
        implements PcepCreateP2pTunnelOutput {
    
        private final LinkId _linkId;
        private final Result _result;
    
        PcepCreateP2pTunnelOutputImpl(PcepCreateP2pTunnelOutputBuilder base) {
            super(base.augmentation);
            this._linkId = base.getLinkId();
            this._result = base.getResult();
        }
    
        @Override
        public LinkId getLinkId() {
            return _linkId;
        }
        
        @Override
        public Result getResult() {
            return _result;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = PcepCreateP2pTunnelOutput.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return PcepCreateP2pTunnelOutput.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return PcepCreateP2pTunnelOutput.bindingToString(this);
        }
    }
}
