package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev181109;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.Nanotime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.SubmitInstructionInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.programming.rev131102.TopologyInstructionInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.BaseTunnelInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.DestroyTunnelInput;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PcepDestroyTunnelInputBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PcepDestroyTunnelInputBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new PcepDestroyTunnelInputBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PcepDestroyTunnelInputBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PcepDestroyTunnelInputBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class PcepDestroyTunnelInputBuilder implements Builder<PcepDestroyTunnelInput> {

    private Nanotime _deadline;
    private InstructionId _id;
    private LinkId _linkId;
    private NetworkTopologyRef _networkTopologyRef;
    private List<InstructionId> _preconditions;


    Map<Class<? extends Augmentation<PcepDestroyTunnelInput>>, Augmentation<PcepDestroyTunnelInput>> augmentation = Collections.emptyMap();

    public PcepDestroyTunnelInputBuilder() {
    }
    
    
    
    public PcepDestroyTunnelInputBuilder(DestroyTunnelInput arg) {
        this._linkId = arg.getLinkId();
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }
    public PcepDestroyTunnelInputBuilder(BaseTunnelInput arg) {
        this._linkId = arg.getLinkId();
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }
    public PcepDestroyTunnelInputBuilder(TopologyInstructionInput arg) {
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }
    public PcepDestroyTunnelInputBuilder(SubmitInstructionInput arg) {
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
    }
    public PcepDestroyTunnelInputBuilder(NetworkTopologyReference arg) {
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }

    public PcepDestroyTunnelInputBuilder(PcepDestroyTunnelInput base) {
        Map<Class<? extends Augmentation<PcepDestroyTunnelInput>>, Augmentation<PcepDestroyTunnelInput>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._deadline = base.getDeadline();
        this._id = base.getId();
        this._linkId = base.getLinkId();
        this._networkTopologyRef = base.getNetworkTopologyRef();
        this._preconditions = base.getPreconditions();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>DestroyTunnelInput</li>
     * <li>TopologyInstructionInput</li>
     * <li>SubmitInstructionInput</li>
     * <li>NetworkTopologyReference</li>
     * <li>BaseTunnelInput</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof DestroyTunnelInput) {
            isValidArg = true;
        }
        if (arg instanceof TopologyInstructionInput) {
            isValidArg = true;
        }
        if (arg instanceof SubmitInstructionInput) {
            this._id = ((SubmitInstructionInput)arg).getId();
            this._deadline = ((SubmitInstructionInput)arg).getDeadline();
            this._preconditions = ((SubmitInstructionInput)arg).getPreconditions();
            isValidArg = true;
        }
        if (arg instanceof NetworkTopologyReference) {
            this._networkTopologyRef = ((NetworkTopologyReference)arg).getNetworkTopologyRef();
            isValidArg = true;
        }
        if (arg instanceof BaseTunnelInput) {
            this._linkId = ((BaseTunnelInput)arg).getLinkId();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[DestroyTunnelInput, TopologyInstructionInput, SubmitInstructionInput, NetworkTopologyReference, BaseTunnelInput]");
    }

    public Nanotime getDeadline() {
        return _deadline;
    }
    
    public InstructionId getId() {
        return _id;
    }
    
    public LinkId getLinkId() {
        return _linkId;
    }
    
    public NetworkTopologyRef getNetworkTopologyRef() {
        return _networkTopologyRef;
    }
    
    public List<InstructionId> getPreconditions() {
        return _preconditions;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<PcepDestroyTunnelInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public PcepDestroyTunnelInputBuilder setDeadline(final Nanotime value) {
        this._deadline = value;
        return this;
    }
    
    public PcepDestroyTunnelInputBuilder setId(final InstructionId value) {
        this._id = value;
        return this;
    }
    
    public PcepDestroyTunnelInputBuilder setLinkId(final LinkId value) {
        this._linkId = value;
        return this;
    }
    
    public PcepDestroyTunnelInputBuilder setNetworkTopologyRef(final NetworkTopologyRef value) {
        this._networkTopologyRef = value;
        return this;
    }
    public PcepDestroyTunnelInputBuilder setPreconditions(final List<InstructionId> values) {
        this._preconditions = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PcepDestroyTunnelInputBuilder addAugmentation(Augmentation<PcepDestroyTunnelInput> augmentation) {
        Class<? extends Augmentation<PcepDestroyTunnelInput>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PcepDestroyTunnelInputBuilder removeAugmentation(Class<? extends Augmentation<PcepDestroyTunnelInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PcepDestroyTunnelInput build() {
        return new PcepDestroyTunnelInputImpl(this);
    }

    private static final class PcepDestroyTunnelInputImpl
        extends AbstractAugmentable<PcepDestroyTunnelInput>
        implements PcepDestroyTunnelInput {
    
        private final Nanotime _deadline;
        private final InstructionId _id;
        private final LinkId _linkId;
        private final NetworkTopologyRef _networkTopologyRef;
        private final List<InstructionId> _preconditions;
    
        PcepDestroyTunnelInputImpl(PcepDestroyTunnelInputBuilder base) {
            super(base.augmentation);
            this._deadline = base.getDeadline();
            this._id = base.getId();
            this._linkId = base.getLinkId();
            this._networkTopologyRef = base.getNetworkTopologyRef();
            this._preconditions = base.getPreconditions();
        }
    
        @Override
        public Nanotime getDeadline() {
            return _deadline;
        }
        
        @Override
        public InstructionId getId() {
            return _id;
        }
        
        @Override
        public LinkId getLinkId() {
            return _linkId;
        }
        
        @Override
        public NetworkTopologyRef getNetworkTopologyRef() {
            return _networkTopologyRef;
        }
        
        @Override
        public List<InstructionId> getPreconditions() {
            return _preconditions;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = PcepDestroyTunnelInput.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return PcepDestroyTunnelInput.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return PcepDestroyTunnelInput.bindingToString(this);
        }
    }
}
