package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev181109;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.Nanotime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.SubmitInstructionInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.programming.rev131102.TopologyInstructionInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.TunnelP2pPathCfgAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.tunnel.p2p.path.cfg.attributes.ExplicitHops;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.tunnel.p2p.path.cfg.attributes.ExplicitHopsKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109.TunnelPcepLinkCfgAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.BaseTunnelInput;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link PcepUpdateTunnelInputBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PcepUpdateTunnelInputBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new PcepUpdateTunnelInputBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PcepUpdateTunnelInputBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PcepUpdateTunnelInputBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class PcepUpdateTunnelInputBuilder implements Builder<PcepUpdateTunnelInput> {

    private Bandwidth _bandwidth;
    private ClassType _classType;
    private Nanotime _deadline;
    private AttributeFilter _excludeAny;
    private Map<ExplicitHopsKey, ExplicitHops> _explicitHops;
    private Uint8 _holdPriority;
    private InstructionId _id;
    private AttributeFilter _includeAll;
    private AttributeFilter _includeAny;
    private Boolean _labelRecordingDesired;
    private LinkId _linkId;
    private Boolean _localProtectionDesired;
    private NetworkTopologyRef _networkTopologyRef;
    private List<InstructionId> _preconditions;
    private Boolean _seStyleDesired;
    private String _sessionName;
    private Uint8 _setupPriority;
    private String _symbolicPathName;


    Map<Class<? extends Augmentation<PcepUpdateTunnelInput>>, Augmentation<PcepUpdateTunnelInput>> augmentation = Collections.emptyMap();

    public PcepUpdateTunnelInputBuilder() {
    }
    
    
    
    public PcepUpdateTunnelInputBuilder(BaseTunnelInput arg) {
        this._linkId = arg.getLinkId();
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }
    public PcepUpdateTunnelInputBuilder(TopologyInstructionInput arg) {
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }
    public PcepUpdateTunnelInputBuilder(SubmitInstructionInput arg) {
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
    }
    public PcepUpdateTunnelInputBuilder(NetworkTopologyReference arg) {
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }
    
    public PcepUpdateTunnelInputBuilder(TunnelP2pPathCfgAttributes arg) {
        this._explicitHops = arg.getExplicitHops();
    }
    
    public PcepUpdateTunnelInputBuilder(TunnelPcepLinkCfgAttributes arg) {
        this._symbolicPathName = arg.getSymbolicPathName();
        this._classType = arg.getClassType();
        this._bandwidth = arg.getBandwidth();
        this._localProtectionDesired = arg.getLocalProtectionDesired();
        this._labelRecordingDesired = arg.getLabelRecordingDesired();
        this._seStyleDesired = arg.getSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    public PcepUpdateTunnelInputBuilder(TunnelAttributes arg) {
        this._localProtectionDesired = arg.getLocalProtectionDesired();
        this._labelRecordingDesired = arg.getLabelRecordingDesired();
        this._seStyleDesired = arg.getSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    public PcepUpdateTunnelInputBuilder(Priority arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
    }
    public PcepUpdateTunnelInputBuilder(AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public PcepUpdateTunnelInputBuilder(PcepUpdateTunnelInput base) {
        Map<Class<? extends Augmentation<PcepUpdateTunnelInput>>, Augmentation<PcepUpdateTunnelInput>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._deadline = base.getDeadline();
        this._excludeAny = base.getExcludeAny();
        this._explicitHops = base.getExplicitHops();
        this._holdPriority = base.getHoldPriority();
        this._id = base.getId();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._labelRecordingDesired = base.getLabelRecordingDesired();
        this._linkId = base.getLinkId();
        this._localProtectionDesired = base.getLocalProtectionDesired();
        this._networkTopologyRef = base.getNetworkTopologyRef();
        this._preconditions = base.getPreconditions();
        this._seStyleDesired = base.getSeStyleDesired();
        this._sessionName = base.getSessionName();
        this._setupPriority = base.getSetupPriority();
        this._symbolicPathName = base.getSymbolicPathName();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>TopologyInstructionInput</li>
     * <li>SubmitInstructionInput</li>
     * <li>TunnelP2pPathCfgAttributes</li>
     * <li>Priority</li>
     * <li>AttributeFilters</li>
     * <li>NetworkTopologyReference</li>
     * <li>TunnelPcepLinkCfgAttributes</li>
     * <li>BaseTunnelInput</li>
     * <li>TunnelAttributes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TopologyInstructionInput) {
            isValidArg = true;
        }
        if (arg instanceof SubmitInstructionInput) {
            this._id = ((SubmitInstructionInput)arg).getId();
            this._deadline = ((SubmitInstructionInput)arg).getDeadline();
            this._preconditions = ((SubmitInstructionInput)arg).getPreconditions();
            isValidArg = true;
        }
        if (arg instanceof TunnelP2pPathCfgAttributes) {
            this._explicitHops = ((TunnelP2pPathCfgAttributes)arg).getExplicitHops();
            isValidArg = true;
        }
        if (arg instanceof Priority) {
            this._holdPriority = ((Priority)arg).getHoldPriority();
            this._setupPriority = ((Priority)arg).getSetupPriority();
            isValidArg = true;
        }
        if (arg instanceof AttributeFilters) {
            this._includeAny = ((AttributeFilters)arg).getIncludeAny();
            this._excludeAny = ((AttributeFilters)arg).getExcludeAny();
            this._includeAll = ((AttributeFilters)arg).getIncludeAll();
            isValidArg = true;
        }
        if (arg instanceof NetworkTopologyReference) {
            this._networkTopologyRef = ((NetworkTopologyReference)arg).getNetworkTopologyRef();
            isValidArg = true;
        }
        if (arg instanceof TunnelPcepLinkCfgAttributes) {
            this._symbolicPathName = ((TunnelPcepLinkCfgAttributes)arg).getSymbolicPathName();
            this._classType = ((TunnelPcepLinkCfgAttributes)arg).getClassType();
            this._bandwidth = ((TunnelPcepLinkCfgAttributes)arg).getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof BaseTunnelInput) {
            this._linkId = ((BaseTunnelInput)arg).getLinkId();
            isValidArg = true;
        }
        if (arg instanceof TunnelAttributes) {
            this._localProtectionDesired = ((TunnelAttributes)arg).getLocalProtectionDesired();
            this._labelRecordingDesired = ((TunnelAttributes)arg).getLabelRecordingDesired();
            this._seStyleDesired = ((TunnelAttributes)arg).getSeStyleDesired();
            this._sessionName = ((TunnelAttributes)arg).getSessionName();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[TopologyInstructionInput, SubmitInstructionInput, TunnelP2pPathCfgAttributes, Priority, AttributeFilters, NetworkTopologyReference, TunnelPcepLinkCfgAttributes, BaseTunnelInput, TunnelAttributes]");
    }

    public Bandwidth getBandwidth() {
        return _bandwidth;
    }
    
    public ClassType getClassType() {
        return _classType;
    }
    
    public Nanotime getDeadline() {
        return _deadline;
    }
    
    public AttributeFilter getExcludeAny() {
        return _excludeAny;
    }
    
    public Map<ExplicitHopsKey, ExplicitHops> getExplicitHops() {
        return _explicitHops;
    }
    
    public Uint8 getHoldPriority() {
        return _holdPriority;
    }
    
    public InstructionId getId() {
        return _id;
    }
    
    public AttributeFilter getIncludeAll() {
        return _includeAll;
    }
    
    public AttributeFilter getIncludeAny() {
        return _includeAny;
    }
    
    public Boolean getLabelRecordingDesired() {
        return _labelRecordingDesired;
    }
    
    public LinkId getLinkId() {
        return _linkId;
    }
    
    public Boolean getLocalProtectionDesired() {
        return _localProtectionDesired;
    }
    
    public NetworkTopologyRef getNetworkTopologyRef() {
        return _networkTopologyRef;
    }
    
    public List<InstructionId> getPreconditions() {
        return _preconditions;
    }
    
    public Boolean getSeStyleDesired() {
        return _seStyleDesired;
    }
    
    public String getSessionName() {
        return _sessionName;
    }
    
    public Uint8 getSetupPriority() {
        return _setupPriority;
    }
    
    public String getSymbolicPathName() {
        return _symbolicPathName;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<PcepUpdateTunnelInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public PcepUpdateTunnelInputBuilder setBandwidth(final Bandwidth value) {
        this._bandwidth = value;
        return this;
    }
    
    public PcepUpdateTunnelInputBuilder setClassType(final ClassType value) {
        this._classType = value;
        return this;
    }
    
    public PcepUpdateTunnelInputBuilder setDeadline(final Nanotime value) {
        this._deadline = value;
        return this;
    }
    
    public PcepUpdateTunnelInputBuilder setExcludeAny(final AttributeFilter value) {
        this._excludeAny = value;
        return this;
    }
    public PcepUpdateTunnelInputBuilder setExplicitHops(final Map<ExplicitHopsKey, ExplicitHops> values) {
        this._explicitHops = values;
        return this;
    }
    
    public PcepUpdateTunnelInputBuilder setHoldPriority(final Uint8 value) {
        this._holdPriority = value;
        return this;
    }
    
    public PcepUpdateTunnelInputBuilder setId(final InstructionId value) {
        this._id = value;
        return this;
    }
    
    public PcepUpdateTunnelInputBuilder setIncludeAll(final AttributeFilter value) {
        this._includeAll = value;
        return this;
    }
    
    public PcepUpdateTunnelInputBuilder setIncludeAny(final AttributeFilter value) {
        this._includeAny = value;
        return this;
    }
    
    public PcepUpdateTunnelInputBuilder setLabelRecordingDesired(final Boolean value) {
        this._labelRecordingDesired = value;
        return this;
    }
    
    public PcepUpdateTunnelInputBuilder setLinkId(final LinkId value) {
        this._linkId = value;
        return this;
    }
    
    public PcepUpdateTunnelInputBuilder setLocalProtectionDesired(final Boolean value) {
        this._localProtectionDesired = value;
        return this;
    }
    
    public PcepUpdateTunnelInputBuilder setNetworkTopologyRef(final NetworkTopologyRef value) {
        this._networkTopologyRef = value;
        return this;
    }
    public PcepUpdateTunnelInputBuilder setPreconditions(final List<InstructionId> values) {
        this._preconditions = values;
        return this;
    }
    
    
    public PcepUpdateTunnelInputBuilder setSeStyleDesired(final Boolean value) {
        this._seStyleDesired = value;
        return this;
    }
    
    public PcepUpdateTunnelInputBuilder setSessionName(final String value) {
        this._sessionName = value;
        return this;
    }
    
    public PcepUpdateTunnelInputBuilder setSetupPriority(final Uint8 value) {
        this._setupPriority = value;
        return this;
    }
    
    public PcepUpdateTunnelInputBuilder setSymbolicPathName(final String value) {
        this._symbolicPathName = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PcepUpdateTunnelInputBuilder addAugmentation(Augmentation<PcepUpdateTunnelInput> augmentation) {
        Class<? extends Augmentation<PcepUpdateTunnelInput>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PcepUpdateTunnelInputBuilder removeAugmentation(Class<? extends Augmentation<PcepUpdateTunnelInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PcepUpdateTunnelInput build() {
        return new PcepUpdateTunnelInputImpl(this);
    }

    private static final class PcepUpdateTunnelInputImpl
        extends AbstractAugmentable<PcepUpdateTunnelInput>
        implements PcepUpdateTunnelInput {
    
        private final Bandwidth _bandwidth;
        private final ClassType _classType;
        private final Nanotime _deadline;
        private final AttributeFilter _excludeAny;
        private final Map<ExplicitHopsKey, ExplicitHops> _explicitHops;
        private final Uint8 _holdPriority;
        private final InstructionId _id;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final Boolean _labelRecordingDesired;
        private final LinkId _linkId;
        private final Boolean _localProtectionDesired;
        private final NetworkTopologyRef _networkTopologyRef;
        private final List<InstructionId> _preconditions;
        private final Boolean _seStyleDesired;
        private final String _sessionName;
        private final Uint8 _setupPriority;
        private final String _symbolicPathName;
    
        PcepUpdateTunnelInputImpl(PcepUpdateTunnelInputBuilder base) {
            super(base.augmentation);
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._deadline = base.getDeadline();
            this._excludeAny = base.getExcludeAny();
            this._explicitHops = CodeHelpers.emptyToNull(base.getExplicitHops());
            this._holdPriority = base.getHoldPriority();
            this._id = base.getId();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._labelRecordingDesired = base.getLabelRecordingDesired();
            this._linkId = base.getLinkId();
            this._localProtectionDesired = base.getLocalProtectionDesired();
            this._networkTopologyRef = base.getNetworkTopologyRef();
            this._preconditions = base.getPreconditions();
            this._seStyleDesired = base.getSeStyleDesired();
            this._sessionName = base.getSessionName();
            this._setupPriority = base.getSetupPriority();
            this._symbolicPathName = base.getSymbolicPathName();
        }
    
        @Override
        public Bandwidth getBandwidth() {
            return _bandwidth;
        }
        
        @Override
        public ClassType getClassType() {
            return _classType;
        }
        
        @Override
        public Nanotime getDeadline() {
            return _deadline;
        }
        
        @Override
        public AttributeFilter getExcludeAny() {
            return _excludeAny;
        }
        
        @Override
        public Map<ExplicitHopsKey, ExplicitHops> getExplicitHops() {
            return _explicitHops;
        }
        
        @Override
        public Uint8 getHoldPriority() {
            return _holdPriority;
        }
        
        @Override
        public InstructionId getId() {
            return _id;
        }
        
        @Override
        public AttributeFilter getIncludeAll() {
            return _includeAll;
        }
        
        @Override
        public AttributeFilter getIncludeAny() {
            return _includeAny;
        }
        
        @Override
        public Boolean getLabelRecordingDesired() {
            return _labelRecordingDesired;
        }
        
        @Override
        public LinkId getLinkId() {
            return _linkId;
        }
        
        @Override
        public Boolean getLocalProtectionDesired() {
            return _localProtectionDesired;
        }
        
        @Override
        public NetworkTopologyRef getNetworkTopologyRef() {
            return _networkTopologyRef;
        }
        
        @Override
        public List<InstructionId> getPreconditions() {
            return _preconditions;
        }
        
        @Override
        public Boolean getSeStyleDesired() {
            return _seStyleDesired;
        }
        
        @Override
        public String getSessionName() {
            return _sessionName;
        }
        
        @Override
        public Uint8 getSetupPriority() {
            return _setupPriority;
        }
        
        @Override
        public String getSymbolicPathName() {
            return _symbolicPathName;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = PcepUpdateTunnelInput.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return PcepUpdateTunnelInput.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return PcepUpdateTunnelInput.bindingToString(this);
        }
    }
}
