package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.BasicExplicitRouteSubobjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ExplicitRouteSubobjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.SubobjectType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ExplicitHops1Builder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ExplicitHops1Builder createTarget(int fooXyzzy, int barBaz) {
 *         return new ExplicitHops1BuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ExplicitHops1Builder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ExplicitHops1Builder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class ExplicitHops1Builder implements Builder<ExplicitHops1> {

    private SubobjectType _subobjectType;



    public ExplicitHops1Builder() {
    }
    
    
    public ExplicitHops1Builder(ExplicitRouteSubobjects arg) {
        this._subobjectType = arg.getSubobjectType();
    }
    public ExplicitHops1Builder(BasicExplicitRouteSubobjects arg) {
        this._subobjectType = arg.getSubobjectType();
    }

    public ExplicitHops1Builder(ExplicitHops1 base) {
        this._subobjectType = base.getSubobjectType();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>BasicExplicitRouteSubobjects</li>
     * <li>ExplicitRouteSubobjects</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BasicExplicitRouteSubobjects) {
            this._subobjectType = ((BasicExplicitRouteSubobjects)arg).getSubobjectType();
            isValidArg = true;
        }
        if (arg instanceof ExplicitRouteSubobjects) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[BasicExplicitRouteSubobjects, ExplicitRouteSubobjects]");
    }

    public SubobjectType getSubobjectType() {
        return _subobjectType;
    }

    
    public ExplicitHops1Builder setSubobjectType(final SubobjectType value) {
        this._subobjectType = value;
        return this;
    }
    

    @Override
    public ExplicitHops1 build() {
        return new ExplicitHops1Impl(this);
    }

    private static final class ExplicitHops1Impl
        implements ExplicitHops1 {
    
        private final SubobjectType _subobjectType;
    
        ExplicitHops1Impl(ExplicitHops1Builder base) {
            this._subobjectType = base.getSubobjectType();
        }
    
        @Override
        public SubobjectType getSubobjectType() {
            return _subobjectType;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ExplicitHops1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ExplicitHops1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ExplicitHops1.bindingToString(this);
        }
    }
}
