package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev181109;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.Nanotime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.SubmitInstructionInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.programming.rev131102.TopologyInstructionInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.TunnelP2pPathCfgAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.tunnel.p2p.path.cfg.attributes.ExplicitHops;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.tunnel.p2p.path.cfg.attributes.ExplicitHopsKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109.TunnelPcepLinkCfgAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.BaseTunnelInput;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkId;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link PcepUpdateTunnelInput} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PcepUpdateTunnelInput createPcepUpdateTunnelInput(int fooXyzzy, int barBaz) {
 *         return new PcepUpdateTunnelInputBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PcepUpdateTunnelInput, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PcepUpdateTunnelInput
 *
 */
@Generated("mdsal-binding-generator")
public class PcepUpdateTunnelInputBuilder {

    private Bandwidth _bandwidth;
    private ClassType _classType;
    private Nanotime _deadline;
    private AttributeFilter _excludeAny;
    private Map<ExplicitHopsKey, ExplicitHops> _explicitHops;
    private Uint8 _holdPriority;
    private InstructionId _id;
    private AttributeFilter _includeAll;
    private AttributeFilter _includeAny;
    private Boolean _labelRecordingDesired;
    private LinkId _linkId;
    private Boolean _localProtectionDesired;
    private NetworkTopologyRef _networkTopologyRef;
    private Set<InstructionId> _preconditions;
    private Boolean _seStyleDesired;
    private String _sessionName;
    private Uint8 _setupPriority;
    private String _symbolicPathName;


    Map<Class<? extends Augmentation<PcepUpdateTunnelInput>>, Augmentation<PcepUpdateTunnelInput>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public PcepUpdateTunnelInputBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link BaseTunnelInput}.
     *
     * @param arg BaseTunnelInput from which the builder should be initialized
     */
    public PcepUpdateTunnelInputBuilder(BaseTunnelInput arg) {
        this._linkId = arg.getLinkId();
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }
    
    /**
     * Construct a new builder initialized from specified {@link TopologyInstructionInput}.
     *
     * @param arg TopologyInstructionInput from which the builder should be initialized
     */
    public PcepUpdateTunnelInputBuilder(TopologyInstructionInput arg) {
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }
    
    /**
     * Construct a new builder initialized from specified {@link SubmitInstructionInput}.
     *
     * @param arg SubmitInstructionInput from which the builder should be initialized
     */
    public PcepUpdateTunnelInputBuilder(SubmitInstructionInput arg) {
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
    }
    
    /**
     * Construct a new builder initialized from specified {@link NetworkTopologyReference}.
     *
     * @param arg NetworkTopologyReference from which the builder should be initialized
     */
    public PcepUpdateTunnelInputBuilder(NetworkTopologyReference arg) {
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link TunnelP2pPathCfgAttributes}.
     *
     * @param arg TunnelP2pPathCfgAttributes from which the builder should be initialized
     */
    public PcepUpdateTunnelInputBuilder(TunnelP2pPathCfgAttributes arg) {
        this._explicitHops = arg.getExplicitHops();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link TunnelPcepLinkCfgAttributes}.
     *
     * @param arg TunnelPcepLinkCfgAttributes from which the builder should be initialized
     */
    public PcepUpdateTunnelInputBuilder(TunnelPcepLinkCfgAttributes arg) {
        this._symbolicPathName = arg.getSymbolicPathName();
        this._classType = arg.getClassType();
        this._bandwidth = arg.getBandwidth();
        this._localProtectionDesired = arg.getLocalProtectionDesired();
        this._labelRecordingDesired = arg.getLabelRecordingDesired();
        this._seStyleDesired = arg.getSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    
    /**
     * Construct a new builder initialized from specified {@link TunnelAttributes}.
     *
     * @param arg TunnelAttributes from which the builder should be initialized
     */
    public PcepUpdateTunnelInputBuilder(TunnelAttributes arg) {
        this._localProtectionDesired = arg.getLocalProtectionDesired();
        this._labelRecordingDesired = arg.getLabelRecordingDesired();
        this._seStyleDesired = arg.getSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    
    /**
     * Construct a new builder initialized from specified {@link Priority}.
     *
     * @param arg Priority from which the builder should be initialized
     */
    public PcepUpdateTunnelInputBuilder(Priority arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
    }
    
    /**
     * Construct a new builder initialized from specified {@link AttributeFilters}.
     *
     * @param arg AttributeFilters from which the builder should be initialized
     */
    public PcepUpdateTunnelInputBuilder(AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link PcepUpdateTunnelInput}.
     *
     * @param base PcepUpdateTunnelInput from which the builder should be initialized
     */
    public PcepUpdateTunnelInputBuilder(PcepUpdateTunnelInput base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._deadline = base.getDeadline();
        this._excludeAny = base.getExcludeAny();
        this._explicitHops = base.getExplicitHops();
        this._holdPriority = base.getHoldPriority();
        this._id = base.getId();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._labelRecordingDesired = base.getLabelRecordingDesired();
        this._linkId = base.getLinkId();
        this._localProtectionDesired = base.getLocalProtectionDesired();
        this._networkTopologyRef = base.getNetworkTopologyRef();
        this._preconditions = base.getPreconditions();
        this._seStyleDesired = base.getSeStyleDesired();
        this._sessionName = base.getSessionName();
        this._setupPriority = base.getSetupPriority();
        this._symbolicPathName = base.getSymbolicPathName();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link TopologyInstructionInput}</li>
     *   <li>{@link SubmitInstructionInput}</li>
     *   <li>{@link TunnelP2pPathCfgAttributes}</li>
     *   <li>{@link Priority}</li>
     *   <li>{@link AttributeFilters}</li>
     *   <li>{@link NetworkTopologyReference}</li>
     *   <li>{@link TunnelPcepLinkCfgAttributes}</li>
     *   <li>{@link BaseTunnelInput}</li>
     *   <li>{@link TunnelAttributes}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TopologyInstructionInput castArg) {
            isValidArg = true;
        }
        if (arg instanceof SubmitInstructionInput castArg) {
            this._id = castArg.getId();
            this._deadline = castArg.getDeadline();
            this._preconditions = castArg.getPreconditions();
            isValidArg = true;
        }
        if (arg instanceof TunnelP2pPathCfgAttributes castArg) {
            this._explicitHops = castArg.getExplicitHops();
            isValidArg = true;
        }
        if (arg instanceof Priority castArg) {
            this._holdPriority = castArg.getHoldPriority();
            this._setupPriority = castArg.getSetupPriority();
            isValidArg = true;
        }
        if (arg instanceof AttributeFilters castArg) {
            this._includeAny = castArg.getIncludeAny();
            this._excludeAny = castArg.getExcludeAny();
            this._includeAll = castArg.getIncludeAll();
            isValidArg = true;
        }
        if (arg instanceof NetworkTopologyReference castArg) {
            this._networkTopologyRef = castArg.getNetworkTopologyRef();
            isValidArg = true;
        }
        if (arg instanceof TunnelPcepLinkCfgAttributes castArg) {
            this._symbolicPathName = castArg.getSymbolicPathName();
            this._classType = castArg.getClassType();
            this._bandwidth = castArg.getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof BaseTunnelInput castArg) {
            this._linkId = castArg.getLinkId();
            isValidArg = true;
        }
        if (arg instanceof TunnelAttributes castArg) {
            this._localProtectionDesired = castArg.getLocalProtectionDesired();
            this._labelRecordingDesired = castArg.getLabelRecordingDesired();
            this._seStyleDesired = castArg.getSeStyleDesired();
            this._sessionName = castArg.getSessionName();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[TopologyInstructionInput, SubmitInstructionInput, TunnelP2pPathCfgAttributes, Priority, AttributeFilters, NetworkTopologyReference, TunnelPcepLinkCfgAttributes, BaseTunnelInput, TunnelAttributes]");
    }


    /**
     * Return current value associated with the property corresponding to {@link PcepUpdateTunnelInput#getBandwidth()}.
     *
     * @return current value
     */
    public Bandwidth getBandwidth() {
        return _bandwidth;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepUpdateTunnelInput#getClassType()}.
     *
     * @return current value
     */
    public ClassType getClassType() {
        return _classType;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepUpdateTunnelInput#getDeadline()}.
     *
     * @return current value
     */
    public Nanotime getDeadline() {
        return _deadline;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepUpdateTunnelInput#getExcludeAny()}.
     *
     * @return current value
     */
    public AttributeFilter getExcludeAny() {
        return _excludeAny;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepUpdateTunnelInput#getExplicitHops()}.
     *
     * @return current value
     */
    public Map<ExplicitHopsKey, ExplicitHops> getExplicitHops() {
        return _explicitHops;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepUpdateTunnelInput#getHoldPriority()}.
     *
     * @return current value
     */
    public Uint8 getHoldPriority() {
        return _holdPriority;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepUpdateTunnelInput#getId()}.
     *
     * @return current value
     */
    public InstructionId getId() {
        return _id;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepUpdateTunnelInput#getIncludeAll()}.
     *
     * @return current value
     */
    public AttributeFilter getIncludeAll() {
        return _includeAll;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepUpdateTunnelInput#getIncludeAny()}.
     *
     * @return current value
     */
    public AttributeFilter getIncludeAny() {
        return _includeAny;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepUpdateTunnelInput#getLabelRecordingDesired()}.
     *
     * @return current value
     */
    public Boolean getLabelRecordingDesired() {
        return _labelRecordingDesired;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepUpdateTunnelInput#getLinkId()}.
     *
     * @return current value
     */
    public LinkId getLinkId() {
        return _linkId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepUpdateTunnelInput#getLocalProtectionDesired()}.
     *
     * @return current value
     */
    public Boolean getLocalProtectionDesired() {
        return _localProtectionDesired;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepUpdateTunnelInput#getNetworkTopologyRef()}.
     *
     * @return current value
     */
    public NetworkTopologyRef getNetworkTopologyRef() {
        return _networkTopologyRef;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepUpdateTunnelInput#getPreconditions()}.
     *
     * @return current value
     */
    public Set<InstructionId> getPreconditions() {
        return _preconditions;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepUpdateTunnelInput#getSeStyleDesired()}.
     *
     * @return current value
     */
    public Boolean getSeStyleDesired() {
        return _seStyleDesired;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepUpdateTunnelInput#getSessionName()}.
     *
     * @return current value
     */
    public String getSessionName() {
        return _sessionName;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepUpdateTunnelInput#getSetupPriority()}.
     *
     * @return current value
     */
    public Uint8 getSetupPriority() {
        return _setupPriority;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepUpdateTunnelInput#getSymbolicPathName()}.
     *
     * @return current value
     */
    public String getSymbolicPathName() {
        return _symbolicPathName;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<PcepUpdateTunnelInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link PcepUpdateTunnelInput#getBandwidth()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepUpdateTunnelInputBuilder setBandwidth(final Bandwidth value) {
        this._bandwidth = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepUpdateTunnelInput#getClassType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepUpdateTunnelInputBuilder setClassType(final ClassType value) {
        this._classType = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepUpdateTunnelInput#getDeadline()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepUpdateTunnelInputBuilder setDeadline(final Nanotime value) {
        this._deadline = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepUpdateTunnelInput#getExcludeAny()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepUpdateTunnelInputBuilder setExcludeAny(final AttributeFilter value) {
        this._excludeAny = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepUpdateTunnelInput#getExplicitHops()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public PcepUpdateTunnelInputBuilder setExplicitHops(final Map<ExplicitHopsKey, ExplicitHops> values) {
        this._explicitHops = values;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepUpdateTunnelInput#getHoldPriority()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepUpdateTunnelInputBuilder setHoldPriority(final Uint8 value) {
        this._holdPriority = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepUpdateTunnelInput#getId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepUpdateTunnelInputBuilder setId(final InstructionId value) {
        this._id = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepUpdateTunnelInput#getIncludeAll()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepUpdateTunnelInputBuilder setIncludeAll(final AttributeFilter value) {
        this._includeAll = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepUpdateTunnelInput#getIncludeAny()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepUpdateTunnelInputBuilder setIncludeAny(final AttributeFilter value) {
        this._includeAny = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepUpdateTunnelInput#getLabelRecordingDesired()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepUpdateTunnelInputBuilder setLabelRecordingDesired(final Boolean value) {
        this._labelRecordingDesired = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepUpdateTunnelInput#getLinkId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepUpdateTunnelInputBuilder setLinkId(final LinkId value) {
        this._linkId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepUpdateTunnelInput#getLocalProtectionDesired()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepUpdateTunnelInputBuilder setLocalProtectionDesired(final Boolean value) {
        this._localProtectionDesired = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepUpdateTunnelInput#getNetworkTopologyRef()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepUpdateTunnelInputBuilder setNetworkTopologyRef(final NetworkTopologyRef value) {
        this._networkTopologyRef = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepUpdateTunnelInput#getPreconditions()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public PcepUpdateTunnelInputBuilder setPreconditions(final Set<InstructionId> values) {
        this._preconditions = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link PcepUpdateTunnelInput#getSeStyleDesired()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepUpdateTunnelInputBuilder setSeStyleDesired(final Boolean value) {
        this._seStyleDesired = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepUpdateTunnelInput#getSessionName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepUpdateTunnelInputBuilder setSessionName(final String value) {
        this._sessionName = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepUpdateTunnelInput#getSetupPriority()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepUpdateTunnelInputBuilder setSetupPriority(final Uint8 value) {
        this._setupPriority = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepUpdateTunnelInput#getSymbolicPathName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepUpdateTunnelInputBuilder setSymbolicPathName(final String value) {
        this._symbolicPathName = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PcepUpdateTunnelInputBuilder addAugmentation(Augmentation<PcepUpdateTunnelInput> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PcepUpdateTunnelInputBuilder removeAugmentation(Class<? extends Augmentation<PcepUpdateTunnelInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link PcepUpdateTunnelInput} instance.
     *
     * @return A new {@link PcepUpdateTunnelInput} instance.
     */
    public @NonNull PcepUpdateTunnelInput build() {
        return new PcepUpdateTunnelInputImpl(this);
    }

    private static final class PcepUpdateTunnelInputImpl
        extends AbstractAugmentable<PcepUpdateTunnelInput>
        implements PcepUpdateTunnelInput {
    
        private final Bandwidth _bandwidth;
        private final ClassType _classType;
        private final Nanotime _deadline;
        private final AttributeFilter _excludeAny;
        private final Map<ExplicitHopsKey, ExplicitHops> _explicitHops;
        private final Uint8 _holdPriority;
        private final InstructionId _id;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final Boolean _labelRecordingDesired;
        private final LinkId _linkId;
        private final Boolean _localProtectionDesired;
        private final NetworkTopologyRef _networkTopologyRef;
        private final Set<InstructionId> _preconditions;
        private final Boolean _seStyleDesired;
        private final String _sessionName;
        private final Uint8 _setupPriority;
        private final String _symbolicPathName;
    
        PcepUpdateTunnelInputImpl(PcepUpdateTunnelInputBuilder base) {
            super(base.augmentation);
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._deadline = base.getDeadline();
            this._excludeAny = base.getExcludeAny();
            this._explicitHops = CodeHelpers.emptyToNull(base.getExplicitHops());
            this._holdPriority = base.getHoldPriority();
            this._id = base.getId();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._labelRecordingDesired = base.getLabelRecordingDesired();
            this._linkId = base.getLinkId();
            this._localProtectionDesired = base.getLocalProtectionDesired();
            this._networkTopologyRef = base.getNetworkTopologyRef();
            this._preconditions = base.getPreconditions();
            this._seStyleDesired = base.getSeStyleDesired();
            this._sessionName = base.getSessionName();
            this._setupPriority = base.getSetupPriority();
            this._symbolicPathName = base.getSymbolicPathName();
        }
    
        @Override
        public Bandwidth getBandwidth() {
            return _bandwidth;
        }
        
        @Override
        public ClassType getClassType() {
            return _classType;
        }
        
        @Override
        public Nanotime getDeadline() {
            return _deadline;
        }
        
        @Override
        public AttributeFilter getExcludeAny() {
            return _excludeAny;
        }
        
        @Override
        public Map<ExplicitHopsKey, ExplicitHops> getExplicitHops() {
            return _explicitHops;
        }
        
        @Override
        public Uint8 getHoldPriority() {
            return _holdPriority;
        }
        
        @Override
        public InstructionId getId() {
            return _id;
        }
        
        @Override
        public AttributeFilter getIncludeAll() {
            return _includeAll;
        }
        
        @Override
        public AttributeFilter getIncludeAny() {
            return _includeAny;
        }
        
        @Override
        public Boolean getLabelRecordingDesired() {
            return _labelRecordingDesired;
        }
        
        @Override
        public LinkId getLinkId() {
            return _linkId;
        }
        
        @Override
        public Boolean getLocalProtectionDesired() {
            return _localProtectionDesired;
        }
        
        @Override
        public NetworkTopologyRef getNetworkTopologyRef() {
            return _networkTopologyRef;
        }
        
        @Override
        public Set<InstructionId> getPreconditions() {
            return _preconditions;
        }
        
        @Override
        public Boolean getSeStyleDesired() {
            return _seStyleDesired;
        }
        
        @Override
        public String getSessionName() {
            return _sessionName;
        }
        
        @Override
        public Uint8 getSetupPriority() {
            return _setupPriority;
        }
        
        @Override
        public String getSymbolicPathName() {
            return _symbolicPathName;
        }
    
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = PcepUpdateTunnelInput.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return PcepUpdateTunnelInput.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return PcepUpdateTunnelInput.bindingToString(this);
        }
    }
}
