package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev181109;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.TunnelP2pPathCfgAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109.TunnelPcepLinkCfgAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.CreateP2pTunnelInput;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>topology-tunnel-pcep-programming</b>
 * <pre>
 * input input {
 *   uses ttp:create-p2p-tunnel-input;
 *   uses p2p:tunnel-p2p-path-cfg-attributes;
 *   uses ptp:tunnel-pcep-link-cfg-attributes;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface PcepCreateP2pTunnelInput
    extends
    RpcInput,
    Augmentable<PcepCreateP2pTunnelInput>,
    CreateP2pTunnelInput,
    TunnelP2pPathCfgAttributes,
    TunnelPcepLinkCfgAttributes
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("input");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev181109.PcepCreateP2pTunnelInput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev181109.PcepCreateP2pTunnelInput.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev181109.@NonNull PcepCreateP2pTunnelInput obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getBandwidth());
        result = prime * result + Objects.hashCode(obj.getClassType());
        result = prime * result + Objects.hashCode(obj.getDeadline());
        result = prime * result + Objects.hashCode(obj.getDestination());
        result = prime * result + Objects.hashCode(obj.getExcludeAny());
        result = prime * result + Objects.hashCode(obj.getExplicitHops());
        result = prime * result + Objects.hashCode(obj.getHoldPriority());
        result = prime * result + Objects.hashCode(obj.getId());
        result = prime * result + Objects.hashCode(obj.getIncludeAll());
        result = prime * result + Objects.hashCode(obj.getIncludeAny());
        result = prime * result + Objects.hashCode(obj.getLabelRecordingDesired());
        result = prime * result + Objects.hashCode(obj.getLocalProtectionDesired());
        result = prime * result + Objects.hashCode(obj.getNetworkTopologyRef());
        result = prime * result + Objects.hashCode(obj.getPreconditions());
        result = prime * result + Objects.hashCode(obj.getSeStyleDesired());
        result = prime * result + Objects.hashCode(obj.getSessionName());
        result = prime * result + Objects.hashCode(obj.getSetupPriority());
        result = prime * result + Objects.hashCode(obj.getSource());
        result = prime * result + Objects.hashCode(obj.getSymbolicPathName());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev181109.@NonNull PcepCreateP2pTunnelInput thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev181109.PcepCreateP2pTunnelInput.class, obj);
        return other != null
            && Objects.equals(thisObj.getClassType(), other.getClassType())
            && Objects.equals(thisObj.getDeadline(), other.getDeadline())
            && Objects.equals(thisObj.getExcludeAny(), other.getExcludeAny())
            && Objects.equals(thisObj.getHoldPriority(), other.getHoldPriority())
            && Objects.equals(thisObj.getIncludeAll(), other.getIncludeAll())
            && Objects.equals(thisObj.getIncludeAny(), other.getIncludeAny())
            && Objects.equals(thisObj.getLabelRecordingDesired(), other.getLabelRecordingDesired())
            && Objects.equals(thisObj.getLocalProtectionDesired(), other.getLocalProtectionDesired())
            && Objects.equals(thisObj.getSeStyleDesired(), other.getSeStyleDesired())
            && Objects.equals(thisObj.getSetupPriority(), other.getSetupPriority())
            && Objects.equals(thisObj.getBandwidth(), other.getBandwidth())
            && Objects.equals(thisObj.getId(), other.getId())
            && Objects.equals(thisObj.getSessionName(), other.getSessionName())
            && Objects.equals(thisObj.getSymbolicPathName(), other.getSymbolicPathName())
            && Objects.equals(thisObj.getNetworkTopologyRef(), other.getNetworkTopologyRef())
            && Objects.equals(thisObj.getDestination(), other.getDestination())
            && Objects.equals(thisObj.getExplicitHops(), other.getExplicitHops())
            && Objects.equals(thisObj.getPreconditions(), other.getPreconditions())
            && Objects.equals(thisObj.getSource(), other.getSource())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev181109.@NonNull PcepCreateP2pTunnelInput obj) {
        final var helper = MoreObjects.toStringHelper("PcepCreateP2pTunnelInput");
        CodeHelpers.appendValue(helper, "bandwidth", obj.getBandwidth());
        CodeHelpers.appendValue(helper, "classType", obj.getClassType());
        CodeHelpers.appendValue(helper, "deadline", obj.getDeadline());
        CodeHelpers.appendValue(helper, "destination", obj.getDestination());
        CodeHelpers.appendValue(helper, "excludeAny", obj.getExcludeAny());
        CodeHelpers.appendValue(helper, "explicitHops", obj.getExplicitHops());
        CodeHelpers.appendValue(helper, "holdPriority", obj.getHoldPriority());
        CodeHelpers.appendValue(helper, "id", obj.getId());
        CodeHelpers.appendValue(helper, "includeAll", obj.getIncludeAll());
        CodeHelpers.appendValue(helper, "includeAny", obj.getIncludeAny());
        CodeHelpers.appendValue(helper, "labelRecordingDesired", obj.getLabelRecordingDesired());
        CodeHelpers.appendValue(helper, "localProtectionDesired", obj.getLocalProtectionDesired());
        CodeHelpers.appendValue(helper, "networkTopologyRef", obj.getNetworkTopologyRef());
        CodeHelpers.appendValue(helper, "preconditions", obj.getPreconditions());
        CodeHelpers.appendValue(helper, "seStyleDesired", obj.getSeStyleDesired());
        CodeHelpers.appendValue(helper, "sessionName", obj.getSessionName());
        CodeHelpers.appendValue(helper, "setupPriority", obj.getSetupPriority());
        CodeHelpers.appendValue(helper, "source", obj.getSource());
        CodeHelpers.appendValue(helper, "symbolicPathName", obj.getSymbolicPathName());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

