package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev181109;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.SubmitInstructionOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.submit.instruction.output.Result;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.programming.rev131102.TopologyInstructionOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.BaseTunnelOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.DestroyTunnelOutput;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PcepDestroyTunnelOutput} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PcepDestroyTunnelOutput createPcepDestroyTunnelOutput(int fooXyzzy, int barBaz) {
 *         return new PcepDestroyTunnelOutputBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PcepDestroyTunnelOutput, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PcepDestroyTunnelOutput
 *
 */
@Generated("mdsal-binding-generator")
public class PcepDestroyTunnelOutputBuilder {

    private Result _result;


    Map<Class<? extends Augmentation<PcepDestroyTunnelOutput>>, Augmentation<PcepDestroyTunnelOutput>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public PcepDestroyTunnelOutputBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link DestroyTunnelOutput}.
     *
     * @param arg DestroyTunnelOutput from which the builder should be initialized
     */
    public PcepDestroyTunnelOutputBuilder(DestroyTunnelOutput arg) {
        this._result = arg.getResult();
    }
    
    /**
     * Construct a new builder initialized from specified {@link BaseTunnelOutput}.
     *
     * @param arg BaseTunnelOutput from which the builder should be initialized
     */
    public PcepDestroyTunnelOutputBuilder(BaseTunnelOutput arg) {
        this._result = arg.getResult();
    }
    
    /**
     * Construct a new builder initialized from specified {@link TopologyInstructionOutput}.
     *
     * @param arg TopologyInstructionOutput from which the builder should be initialized
     */
    public PcepDestroyTunnelOutputBuilder(TopologyInstructionOutput arg) {
        this._result = arg.getResult();
    }
    
    /**
     * Construct a new builder initialized from specified {@link SubmitInstructionOutput}.
     *
     * @param arg SubmitInstructionOutput from which the builder should be initialized
     */
    public PcepDestroyTunnelOutputBuilder(SubmitInstructionOutput arg) {
        this._result = arg.getResult();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link PcepDestroyTunnelOutput}.
     *
     * @param base PcepDestroyTunnelOutput from which the builder should be initialized
     */
    public PcepDestroyTunnelOutputBuilder(PcepDestroyTunnelOutput base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._result = base.getResult();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link BaseTunnelOutput}</li>
     *   <li>{@link TopologyInstructionOutput}</li>
     *   <li>{@link DestroyTunnelOutput}</li>
     *   <li>{@link SubmitInstructionOutput}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BaseTunnelOutput castArg) {
            isValidArg = true;
        }
        if (arg instanceof TopologyInstructionOutput castArg) {
            isValidArg = true;
        }
        if (arg instanceof DestroyTunnelOutput castArg) {
            isValidArg = true;
        }
        if (arg instanceof SubmitInstructionOutput castArg) {
            this._result = castArg.getResult();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[BaseTunnelOutput, TopologyInstructionOutput, DestroyTunnelOutput, SubmitInstructionOutput]");
    }


    /**
     * Return current value associated with the property corresponding to {@link PcepDestroyTunnelOutput#getResult()}.
     *
     * @return current value
     */
    public Result getResult() {
        return _result;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<PcepDestroyTunnelOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link PcepDestroyTunnelOutput#getResult()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepDestroyTunnelOutputBuilder setResult(final Result value) {
        this._result = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PcepDestroyTunnelOutputBuilder addAugmentation(Augmentation<PcepDestroyTunnelOutput> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PcepDestroyTunnelOutputBuilder removeAugmentation(Class<? extends Augmentation<PcepDestroyTunnelOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link PcepDestroyTunnelOutput} instance.
     *
     * @return A new {@link PcepDestroyTunnelOutput} instance.
     */
    public @NonNull PcepDestroyTunnelOutput build() {
        return new PcepDestroyTunnelOutputImpl(this);
    }

    private static final class PcepDestroyTunnelOutputImpl
        extends AbstractAugmentable<PcepDestroyTunnelOutput>
        implements PcepDestroyTunnelOutput {
    
        private final Result _result;
    
        PcepDestroyTunnelOutputImpl(PcepDestroyTunnelOutputBuilder base) {
            super(base.augmentation);
            this._result = base.getResult();
        }
    
        @Override
        public Result getResult() {
            return _result;
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = PcepDestroyTunnelOutput.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return PcepDestroyTunnelOutput.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return PcepDestroyTunnelOutput.bindingToString(this);
        }
    }
}
