package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>topology-tunnel-pcep</b>
 * <pre>
 * augment /nt:network-topology/nt:topology/nt:link {
 *   when ../../tunnel-types/pcep-tunnel;
 *   uses tunnel-pcep-link-cfg-attributes;
 *   uses tunnel-pcep-link-oper-attributes;
 * }
 * </pre>
 *
 * @see Link
 *
 */
@Generated("mdsal-binding-generator")
public interface Link1
    extends
    Augmentation<Link>,
    TunnelPcepLinkCfgAttributes,
    TunnelPcepLinkOperAttributes
{




    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109.Link1> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109.Link1.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109.@NonNull Link1 obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getBandwidth());
        result = prime * result + Objects.hashCode(obj.getClassType());
        result = prime * result + Objects.hashCode(obj.getExcludeAny());
        result = prime * result + Objects.hashCode(obj.getHoldPriority());
        result = prime * result + Objects.hashCode(obj.getIncludeAll());
        result = prime * result + Objects.hashCode(obj.getIncludeAny());
        result = prime * result + Objects.hashCode(obj.getLabelRecordingDesired());
        result = prime * result + Objects.hashCode(obj.getLocalProtectionDesired());
        result = prime * result + Objects.hashCode(obj.getSeStyleDesired());
        result = prime * result + Objects.hashCode(obj.getSessionName());
        result = prime * result + Objects.hashCode(obj.getSetupPriority());
        result = prime * result + Objects.hashCode(obj.getSymbolicPathName());
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109.@NonNull Link1 thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109.Link1.class, obj);
        return other != null
            && Objects.equals(thisObj.getClassType(), other.getClassType())
            && Objects.equals(thisObj.getExcludeAny(), other.getExcludeAny())
            && Objects.equals(thisObj.getHoldPriority(), other.getHoldPriority())
            && Objects.equals(thisObj.getIncludeAll(), other.getIncludeAll())
            && Objects.equals(thisObj.getIncludeAny(), other.getIncludeAny())
            && Objects.equals(thisObj.getLabelRecordingDesired(), other.getLabelRecordingDesired())
            && Objects.equals(thisObj.getLocalProtectionDesired(), other.getLocalProtectionDesired())
            && Objects.equals(thisObj.getSeStyleDesired(), other.getSeStyleDesired())
            && Objects.equals(thisObj.getSetupPriority(), other.getSetupPriority())
            && Objects.equals(thisObj.getBandwidth(), other.getBandwidth())
            && Objects.equals(thisObj.getSessionName(), other.getSessionName())
            && Objects.equals(thisObj.getSymbolicPathName(), other.getSymbolicPathName())
            ;
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109.@NonNull Link1 obj) {
        final var helper = MoreObjects.toStringHelper("Link1");
        CodeHelpers.appendValue(helper, "bandwidth", obj.getBandwidth());
        CodeHelpers.appendValue(helper, "classType", obj.getClassType());
        CodeHelpers.appendValue(helper, "excludeAny", obj.getExcludeAny());
        CodeHelpers.appendValue(helper, "holdPriority", obj.getHoldPriority());
        CodeHelpers.appendValue(helper, "includeAll", obj.getIncludeAll());
        CodeHelpers.appendValue(helper, "includeAny", obj.getIncludeAny());
        CodeHelpers.appendValue(helper, "labelRecordingDesired", obj.getLabelRecordingDesired());
        CodeHelpers.appendValue(helper, "localProtectionDesired", obj.getLocalProtectionDesired());
        CodeHelpers.appendValue(helper, "seStyleDesired", obj.getSeStyleDesired());
        CodeHelpers.appendValue(helper, "sessionName", obj.getSessionName());
        CodeHelpers.appendValue(helper, "setupPriority", obj.getSetupPriority());
        CodeHelpers.appendValue(helper, "symbolicPathName", obj.getSymbolicPathName());
        return helper.toString();
    }

}

