package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109;
import java.lang.Boolean;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RecordRouteSubobjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.SubobjectType;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ReportedHops1} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ReportedHops1 createReportedHops1(int fooXyzzy, int barBaz) {
 *         return new ReportedHops1Builder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ReportedHops1, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ReportedHops1
 *
 */
@Generated("mdsal-binding-generator")
public class ReportedHops1Builder {

    private Boolean _protectionAvailable;
    private Boolean _protectionInUse;
    private SubobjectType _subobjectType;



    /**
     * Construct an empty builder.
     */
    public ReportedHops1Builder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link RecordRouteSubobjects}.
     *
     * @param arg RecordRouteSubobjects from which the builder should be initialized
     */
    public ReportedHops1Builder(RecordRouteSubobjects arg) {
        this._protectionAvailable = arg.getProtectionAvailable();
        this._protectionInUse = arg.getProtectionInUse();
        this._subobjectType = arg.getSubobjectType();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link ReportedHops1}.
     *
     * @param base ReportedHops1 from which the builder should be initialized
     */
    public ReportedHops1Builder(ReportedHops1 base) {
        this._protectionAvailable = base.getProtectionAvailable();
        this._protectionInUse = base.getProtectionInUse();
        this._subobjectType = base.getSubobjectType();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link RecordRouteSubobjects}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RecordRouteSubobjects castArg) {
            this._protectionAvailable = castArg.getProtectionAvailable();
            this._protectionInUse = castArg.getProtectionInUse();
            this._subobjectType = castArg.getSubobjectType();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[RecordRouteSubobjects]");
    }


    /**
     * Return current value associated with the property corresponding to {@link ReportedHops1#getProtectionAvailable()}.
     *
     * @return current value
     */
    public Boolean getProtectionAvailable() {
        return _protectionAvailable;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ReportedHops1#getProtectionInUse()}.
     *
     * @return current value
     */
    public Boolean getProtectionInUse() {
        return _protectionInUse;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ReportedHops1#getSubobjectType()}.
     *
     * @return current value
     */
    public SubobjectType getSubobjectType() {
        return _subobjectType;
    }

    
    /**
     * Set the property corresponding to {@link ReportedHops1#getProtectionAvailable()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ReportedHops1Builder setProtectionAvailable(final Boolean value) {
        this._protectionAvailable = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ReportedHops1#getProtectionInUse()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ReportedHops1Builder setProtectionInUse(final Boolean value) {
        this._protectionInUse = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ReportedHops1#getSubobjectType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ReportedHops1Builder setSubobjectType(final SubobjectType value) {
        this._subobjectType = value;
        return this;
    }
    

    /**
     * A new {@link ReportedHops1} instance.
     *
     * @return A new {@link ReportedHops1} instance.
     */
    public @NonNull ReportedHops1 build() {
        return new ReportedHops1Impl(this);
    }

    private static final class ReportedHops1Impl
        implements ReportedHops1 {
    
        private final Boolean _protectionAvailable;
        private final Boolean _protectionInUse;
        private final SubobjectType _subobjectType;
    
        ReportedHops1Impl(ReportedHops1Builder base) {
            this._protectionAvailable = base.getProtectionAvailable();
            this._protectionInUse = base.getProtectionInUse();
            this._subobjectType = base.getSubobjectType();
        }
    
        @Override
        public Boolean getProtectionAvailable() {
            return _protectionAvailable;
        }
        
        @Override
        public Boolean getProtectionInUse() {
            return _protectionInUse;
        }
        
        @Override
        public SubobjectType getSubobjectType() {
            return _subobjectType;
        }
    
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ReportedHops1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ReportedHops1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ReportedHops1.bindingToString(this);
        }
    }
}
