package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>topology-tunnel-pcep</b>
 * <pre>
 * grouping tunnel-pcep-link-cfg-attributes {
 *   leaf symbolic-path-name {
 *     type string;
 *   }
 *   leaf class-type {
 *     type pcep:class-type;
 *   }
 *   leaf bandwidth {
 *     type netc:bandwidth;
 *   }
 *   uses rsvp:tunnel-attributes;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface TunnelPcepLinkCfgAttributes
    extends
    DataObject,
    TunnelAttributes
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("tunnel-pcep-link-cfg-attributes");

    @Override
    Class<? extends TunnelPcepLinkCfgAttributes> implementedInterface();
    
    /**
     * Return symbolicPathName, or {@code null} if it is not present.
     *
     * @return {@code String} symbolicPathName, or {@code null} if it is not present.
     *
     */
    String getSymbolicPathName();
    
    /**
     * Return symbolicPathName, guaranteed to be non-null.
     *
     * @return {@code String} symbolicPathName, guaranteed to be non-null.
     * @throws NoSuchElementException if symbolicPathName is not present
     *
     */
    default @NonNull String requireSymbolicPathName() {
        return CodeHelpers.require(getSymbolicPathName(), "symbolicpathname");
    }
    
    /**
     * Return classType, or {@code null} if it is not present.
     *
     * @return {@code ClassType} classType, or {@code null} if it is not present.
     *
     */
    ClassType getClassType();
    
    /**
     * Return classType, guaranteed to be non-null.
     *
     * @return {@code ClassType} classType, guaranteed to be non-null.
     * @throws NoSuchElementException if classType is not present
     *
     */
    default @NonNull ClassType requireClassType() {
        return CodeHelpers.require(getClassType(), "classtype");
    }
    
    /**
     * Return bandwidth, or {@code null} if it is not present.
     *
     * @return {@code Bandwidth} bandwidth, or {@code null} if it is not present.
     *
     */
    Bandwidth getBandwidth();
    
    /**
     * Return bandwidth, guaranteed to be non-null.
     *
     * @return {@code Bandwidth} bandwidth, guaranteed to be non-null.
     * @throws NoSuchElementException if bandwidth is not present
     *
     */
    default @NonNull Bandwidth requireBandwidth() {
        return CodeHelpers.require(getBandwidth(), "bandwidth");
    }

}

