package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.config.rev181109;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.config.rev181109.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>topology-tunnel-pcep-config</b>
 * <pre>
 * grouping topology-ref {
 *   leaf pcep-topology-reference {
 *     type leafref {
 *       path /nt:network-topology/nt:topology/nt:topology-id;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface TopologyRef
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("topology-ref");

    @Override
    Class<? extends TopologyRef> implementedInterface();
    
    /**
     * Return pcepTopologyReference, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         An absolute reference to a topology instance.
     *     </code>
     * </pre>
     *
     * @return {@code TopologyId} pcepTopologyReference, or {@code null} if it is not present.
     *
     */
    TopologyId getPcepTopologyReference();
    
    /**
     * Return pcepTopologyReference, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         An absolute reference to a topology instance.
     *     </code>
     * </pre>
     *
     * @return {@code TopologyId} pcepTopologyReference, guaranteed to be non-null.
     * @throws NoSuchElementException if pcepTopologyReference is not present
     *
     */
    default @NonNull TopologyId requirePcepTopologyReference() {
        return CodeHelpers.require(getPcepTopologyReference(), "pceptopologyreference");
    }

}

