package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109;
import java.lang.Boolean;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link Link1} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Link1 createLink1(int fooXyzzy, int barBaz) {
 *         return new Link1Builder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Link1, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Link1
 *
 */
@Generated("mdsal-binding-generator")
public class Link1Builder {

    private Bandwidth _bandwidth;
    private ClassType _classType;
    private AttributeFilter _excludeAny;
    private Uint8 _holdPriority;
    private AttributeFilter _includeAll;
    private AttributeFilter _includeAny;
    private Boolean _labelRecordingDesired;
    private Boolean _localProtectionDesired;
    private Boolean _seStyleDesired;
    private String _sessionName;
    private Uint8 _setupPriority;
    private String _symbolicPathName;



    /**
     * Construct an empty builder.
     */
    public Link1Builder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link TunnelPcepLinkCfgAttributes}.
     *
     * @param arg TunnelPcepLinkCfgAttributes from which the builder should be initialized
     */
    public Link1Builder(TunnelPcepLinkCfgAttributes arg) {
        this._symbolicPathName = arg.getSymbolicPathName();
        this._classType = arg.getClassType();
        this._bandwidth = arg.getBandwidth();
        this._localProtectionDesired = arg.getLocalProtectionDesired();
        this._labelRecordingDesired = arg.getLabelRecordingDesired();
        this._seStyleDesired = arg.getSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    
    /**
     * Construct a new builder initialized from specified {@link TunnelAttributes}.
     *
     * @param arg TunnelAttributes from which the builder should be initialized
     */
    public Link1Builder(TunnelAttributes arg) {
        this._localProtectionDesired = arg.getLocalProtectionDesired();
        this._labelRecordingDesired = arg.getLabelRecordingDesired();
        this._seStyleDesired = arg.getSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    
    /**
     * Construct a new builder initialized from specified {@link Priority}.
     *
     * @param arg Priority from which the builder should be initialized
     */
    public Link1Builder(Priority arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
    }
    
    /**
     * Construct a new builder initialized from specified {@link AttributeFilters}.
     *
     * @param arg AttributeFilters from which the builder should be initialized
     */
    public Link1Builder(AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link Link1}.
     *
     * @param base Link1 from which the builder should be initialized
     */
    public Link1Builder(final Link1 base) {
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._excludeAny = base.getExcludeAny();
        this._holdPriority = base.getHoldPriority();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._labelRecordingDesired = base.getLabelRecordingDesired();
        this._localProtectionDesired = base.getLocalProtectionDesired();
        this._seStyleDesired = base.getSeStyleDesired();
        this._sessionName = base.getSessionName();
        this._setupPriority = base.getSetupPriority();
        this._symbolicPathName = base.getSymbolicPathName();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link Priority}</li>
     *   <li>{@link AttributeFilters}</li>
     *   <li>{@link TunnelPcepLinkCfgAttributes}</li>
     *   <li>{@link TunnelAttributes}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof Priority castArg) {
            this._holdPriority = castArg.getHoldPriority();
            this._setupPriority = castArg.getSetupPriority();
            isValidArg = true;
        }
        if (arg instanceof AttributeFilters castArg) {
            this._includeAny = castArg.getIncludeAny();
            this._excludeAny = castArg.getExcludeAny();
            this._includeAll = castArg.getIncludeAll();
            isValidArg = true;
        }
        if (arg instanceof TunnelPcepLinkCfgAttributes castArg) {
            this._symbolicPathName = castArg.getSymbolicPathName();
            this._classType = castArg.getClassType();
            this._bandwidth = castArg.getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof TunnelAttributes castArg) {
            this._localProtectionDesired = castArg.getLocalProtectionDesired();
            this._labelRecordingDesired = castArg.getLabelRecordingDesired();
            this._seStyleDesired = castArg.getSeStyleDesired();
            this._sessionName = castArg.getSessionName();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[Priority, AttributeFilters, TunnelPcepLinkCfgAttributes, TunnelAttributes]");
    }


    /**
     * Return current value associated with the property corresponding to {@link Link1#getBandwidth()}.
     *
     * @return current value
     */
    public Bandwidth getBandwidth() {
        return _bandwidth;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Link1#getClassType()}.
     *
     * @return current value
     */
    public ClassType getClassType() {
        return _classType;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Link1#getExcludeAny()}.
     *
     * @return current value
     */
    public AttributeFilter getExcludeAny() {
        return _excludeAny;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Link1#getHoldPriority()}.
     *
     * @return current value
     */
    public Uint8 getHoldPriority() {
        return _holdPriority;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Link1#getIncludeAll()}.
     *
     * @return current value
     */
    public AttributeFilter getIncludeAll() {
        return _includeAll;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Link1#getIncludeAny()}.
     *
     * @return current value
     */
    public AttributeFilter getIncludeAny() {
        return _includeAny;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Link1#getLabelRecordingDesired()}.
     *
     * @return current value
     */
    public Boolean getLabelRecordingDesired() {
        return _labelRecordingDesired;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Link1#getLocalProtectionDesired()}.
     *
     * @return current value
     */
    public Boolean getLocalProtectionDesired() {
        return _localProtectionDesired;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Link1#getSeStyleDesired()}.
     *
     * @return current value
     */
    public Boolean getSeStyleDesired() {
        return _seStyleDesired;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Link1#getSessionName()}.
     *
     * @return current value
     */
    public String getSessionName() {
        return _sessionName;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Link1#getSetupPriority()}.
     *
     * @return current value
     */
    public Uint8 getSetupPriority() {
        return _setupPriority;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Link1#getSymbolicPathName()}.
     *
     * @return current value
     */
    public String getSymbolicPathName() {
        return _symbolicPathName;
    }

    
    /**
     * Set the property corresponding to {@link Link1#getBandwidth()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Link1Builder setBandwidth(final Bandwidth value) {
        this._bandwidth = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Link1#getClassType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Link1Builder setClassType(final ClassType value) {
        this._classType = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Link1#getExcludeAny()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Link1Builder setExcludeAny(final AttributeFilter value) {
        this._excludeAny = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Link1#getHoldPriority()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Link1Builder setHoldPriority(final Uint8 value) {
        this._holdPriority = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Link1#getIncludeAll()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Link1Builder setIncludeAll(final AttributeFilter value) {
        this._includeAll = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Link1#getIncludeAny()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Link1Builder setIncludeAny(final AttributeFilter value) {
        this._includeAny = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Link1#getLabelRecordingDesired()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Link1Builder setLabelRecordingDesired(final Boolean value) {
        this._labelRecordingDesired = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Link1#getLocalProtectionDesired()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Link1Builder setLocalProtectionDesired(final Boolean value) {
        this._localProtectionDesired = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Link1#getSeStyleDesired()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Link1Builder setSeStyleDesired(final Boolean value) {
        this._seStyleDesired = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Link1#getSessionName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Link1Builder setSessionName(final String value) {
        this._sessionName = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Link1#getSetupPriority()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Link1Builder setSetupPriority(final Uint8 value) {
        this._setupPriority = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Link1#getSymbolicPathName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Link1Builder setSymbolicPathName(final String value) {
        this._symbolicPathName = value;
        return this;
    }
    

    /**
     * A new {@link Link1} instance.
     *
     * @return A new {@link Link1} instance.
     */
    public @NonNull Link1 build() {
        return new Link1Impl(this);
    }

    private static final class Link1Impl
        implements Link1 {
    
        private final Bandwidth _bandwidth;
        private final ClassType _classType;
        private final AttributeFilter _excludeAny;
        private final Uint8 _holdPriority;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final Boolean _labelRecordingDesired;
        private final Boolean _localProtectionDesired;
        private final Boolean _seStyleDesired;
        private final String _sessionName;
        private final Uint8 _setupPriority;
        private final String _symbolicPathName;
    
        Link1Impl(final Link1Builder base) {
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._excludeAny = base.getExcludeAny();
            this._holdPriority = base.getHoldPriority();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._labelRecordingDesired = base.getLabelRecordingDesired();
            this._localProtectionDesired = base.getLocalProtectionDesired();
            this._seStyleDesired = base.getSeStyleDesired();
            this._sessionName = base.getSessionName();
            this._setupPriority = base.getSetupPriority();
            this._symbolicPathName = base.getSymbolicPathName();
        }
    
        @Override
        public Bandwidth getBandwidth() {
            return _bandwidth;
        }
        
        @Override
        public ClassType getClassType() {
            return _classType;
        }
        
        @Override
        public AttributeFilter getExcludeAny() {
            return _excludeAny;
        }
        
        @Override
        public Uint8 getHoldPriority() {
            return _holdPriority;
        }
        
        @Override
        public AttributeFilter getIncludeAll() {
            return _includeAll;
        }
        
        @Override
        public AttributeFilter getIncludeAny() {
            return _includeAny;
        }
        
        @Override
        public Boolean getLabelRecordingDesired() {
            return _labelRecordingDesired;
        }
        
        @Override
        public Boolean getLocalProtectionDesired() {
            return _localProtectionDesired;
        }
        
        @Override
        public Boolean getSeStyleDesired() {
            return _seStyleDesired;
        }
        
        @Override
        public String getSessionName() {
            return _sessionName;
        }
        
        @Override
        public Uint8 getSetupPriority() {
            return _setupPriority;
        }
        
        @Override
        public String getSymbolicPathName() {
            return _symbolicPathName;
        }
    
        
        
        
        
        
        
        
        
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Link1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Link1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Link1.bindingToString(this);
        }
    }
}
