package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109.tunnel.pcep.supporting.node.attributes.PathComputationClient;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * Class that builds {@link SupportingNode1} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SupportingNode1 createSupportingNode1(int fooXyzzy, int barBaz) {
 *         return new SupportingNode1Builder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SupportingNode1, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SupportingNode1
 *
 */
@Generated("mdsal-binding-generator")
public class SupportingNode1Builder {

    private PathComputationClient _pathComputationClient;



    /**
     * Construct an empty builder.
     */
    public SupportingNode1Builder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link TunnelPcepSupportingNodeAttributes}.
     *
     * @param arg TunnelPcepSupportingNodeAttributes from which the builder should be initialized
     */
    public SupportingNode1Builder(TunnelPcepSupportingNodeAttributes arg) {
        this._pathComputationClient = arg.getPathComputationClient();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link SupportingNode1}.
     *
     * @param base SupportingNode1 from which the builder should be initialized
     */
    public SupportingNode1Builder(final SupportingNode1 base) {
        this._pathComputationClient = base.getPathComputationClient();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link TunnelPcepSupportingNodeAttributes}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof TunnelPcepSupportingNodeAttributes castArg) {
            this._pathComputationClient = castArg.getPathComputationClient();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[TunnelPcepSupportingNodeAttributes]");
    }


    /**
     * Return current value associated with the property corresponding to {@link SupportingNode1#getPathComputationClient()}.
     *
     * @return current value
     */
    public PathComputationClient getPathComputationClient() {
        return _pathComputationClient;
    }

    
    /**
     * Set the property corresponding to {@link SupportingNode1#getPathComputationClient()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SupportingNode1Builder setPathComputationClient(final PathComputationClient value) {
        this._pathComputationClient = value;
        return this;
    }
    

    /**
     * A new {@link SupportingNode1} instance.
     *
     * @return A new {@link SupportingNode1} instance.
     */
    public @NonNull SupportingNode1 build() {
        return new SupportingNode1Impl(this);
    }

    private static final class SupportingNode1Impl
        implements SupportingNode1 {
    
        private final PathComputationClient _pathComputationClient;
    
        SupportingNode1Impl(final SupportingNode1Builder base) {
            this._pathComputationClient = base.getPathComputationClient();
        }
    
        @Override
        public PathComputationClient getPathComputationClient() {
            return _pathComputationClient;
        }
    
        @Override
        public PathComputationClient nonnullPathComputationClient() {
            return Objects.requireNonNullElse(getPathComputationClient(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109.tunnel.pcep.supporting.node.attributes.PathComputationClientBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = SupportingNode1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return SupportingNode1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return SupportingNode1.bindingToString(this);
        }
    }
}
