package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109.tunnel.pcep.type.PcepTunnel;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * Class that builds {@link TunnelTypes1} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     TunnelTypes1 createTunnelTypes1(int fooXyzzy, int barBaz) {
 *         return new TunnelTypes1Builder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of TunnelTypes1, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see TunnelTypes1
 *
 */
@Generated("mdsal-binding-generator")
public class TunnelTypes1Builder {

    private PcepTunnel _pcepTunnel;



    /**
     * Construct an empty builder.
     */
    public TunnelTypes1Builder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link TunnelPcepType}.
     *
     * @param arg TunnelPcepType from which the builder should be initialized
     */
    public TunnelTypes1Builder(TunnelPcepType arg) {
        this._pcepTunnel = arg.getPcepTunnel();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link TunnelTypes1}.
     *
     * @param base TunnelTypes1 from which the builder should be initialized
     */
    public TunnelTypes1Builder(final TunnelTypes1 base) {
        this._pcepTunnel = base.getPcepTunnel();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link TunnelPcepType}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof TunnelPcepType castArg) {
            this._pcepTunnel = castArg.getPcepTunnel();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[TunnelPcepType]");
    }


    /**
     * Return current value associated with the property corresponding to {@link TunnelTypes1#getPcepTunnel()}.
     *
     * @return current value
     */
    public PcepTunnel getPcepTunnel() {
        return _pcepTunnel;
    }

    
    /**
     * Set the property corresponding to {@link TunnelTypes1#getPcepTunnel()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TunnelTypes1Builder setPcepTunnel(final PcepTunnel value) {
        this._pcepTunnel = value;
        return this;
    }
    

    /**
     * A new {@link TunnelTypes1} instance.
     *
     * @return A new {@link TunnelTypes1} instance.
     */
    public @NonNull TunnelTypes1 build() {
        return new TunnelTypes1Impl(this);
    }

    private static final class TunnelTypes1Impl
        implements TunnelTypes1 {
    
        private final PcepTunnel _pcepTunnel;
    
        TunnelTypes1Impl(final TunnelTypes1Builder base) {
            this._pcepTunnel = base.getPcepTunnel();
        }
    
        @Override
        public PcepTunnel getPcepTunnel() {
            return _pcepTunnel;
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = TunnelTypes1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return TunnelTypes1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return TunnelTypes1.bindingToString(this);
        }
    }
}
